/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.MultiMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigFileSearcher {
    private final MultiMap<Module, PsiFile> myFiles;
    private final MultiMap<VirtualFile, PsiFile> myJars;
    private final MultiMap<VirtualFile, PsiFile> myVirtualFiles;
    @Nullable
    private final Module myModule;
    @NotNull
    private final Project myProject;

    public ConfigFileSearcher(@Nullable Module module, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xml/config/ConfigFileSearcher", "<init>"));
        }
        this.myFiles = new MultiMap();
        this.myJars = new MultiMap();
        this.myVirtualFiles = new MultiMap();
        this.myModule = module;
        this.myProject = project;
    }

    public void search() {
        this.myFiles.clear();
        this.myJars.clear();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (PsiFile file : this.search(this.myModule, this.myProject)) {
            VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(file.getVirtualFile());
            if (jar != null) {
                this.myJars.putValue((Object)jar, (Object)file);
                continue;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module != null) {
                this.myFiles.putValue((Object)module, (Object)file);
                continue;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            this.myVirtualFiles.putValue((Object)virtualFile.getParent(), (Object)psiManager.findFile(virtualFile));
        }
    }

    public abstract Set<PsiFile> search(@Nullable Module var1, @NotNull Project var2);

    public MultiMap<Module, PsiFile> getFilesByModules() {
        return this.myFiles;
    }

    public MultiMap<VirtualFile, PsiFile> getJars() {
        return this.myJars;
    }

    public MultiMap<VirtualFile, PsiFile> getVirtualFiles() {
        return this.myVirtualFiles;
    }
}

