/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EvaluatingExpressionRootNode
extends XValueContainerNode<EvaluatingResultContainer> {
    public EvaluatingExpressionRootNode(XDebuggerEvaluationDialog evaluationDialog, XDebuggerTree tree) {
        super(tree, null, new EvaluatingResultContainer(evaluationDialog, tree));
        this.setLeaf(false);
    }

    @Override
    protected MessageTreeNode createLoadingMessageNode() {
        return MessageTreeNode.createEvaluatingMessage(this.myTree, this);
    }

    public static class EvaluatingResultContainer
    extends XValueContainer
    implements XDebuggerTreeListener {
        private final XDebuggerEvaluationDialog myDialog;
        private final XDebuggerTree myTree;

        public EvaluatingResultContainer(XDebuggerEvaluationDialog dialog, XDebuggerTree tree) {
            this.myDialog = dialog;
            this.myTree = tree;
        }

        public void computeChildren(final @NotNull XCompositeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/nodes/EvaluatingExpressionRootNode$EvaluatingResultContainer", "computeChildren"));
            }
            this.myDialog.startEvaluation(new XEvaluationCallbackBase(){

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/nodes/EvaluatingExpressionRootNode$EvaluatingResultContainer$1", "evaluated"));
                    }
                    EvaluatingResultContainer.this.myTree.addTreeListener(EvaluatingResultContainer.this);
                    String name = UIUtil.removeMnemonic((String)XDebuggerBundle.message((String)"xdebugger.evaluate.result", (Object[])new Object[0]));
                    node.addChildren(XValueChildrenList.singleton((String)name, (XValue)result), true);
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/nodes/EvaluatingExpressionRootNode$EvaluatingResultContainer$1", "errorOccurred"));
                    }
                    node.setErrorMessage(errorMessage);
                }
            });
        }

        @Override
        public void nodeLoaded(@NotNull RestorableStateNode node, String name) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/nodes/EvaluatingExpressionRootNode$EvaluatingResultContainer", "nodeLoaded"));
            }
            if (node.getParent() instanceof EvaluatingExpressionRootNode) {
                if (node.isLeaf()) {
                    this.myTree.removeTreeListener(this);
                } else {
                    node.getChildCount();
                }
            }
        }

        @Override
        public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<XValueContainerNode<?>> children, boolean last) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/nodes/EvaluatingExpressionRootNode$EvaluatingResultContainer", "childrenLoaded"));
            }
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/ui/tree/nodes/EvaluatingExpressionRootNode$EvaluatingResultContainer", "childrenLoaded"));
            }
            if (node.getParent() instanceof EvaluatingExpressionRootNode) {
                this.myTree.removeTreeListener(this);
                this.myTree.expandPath(node.getPath());
            }
        }
    }
}

