/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchMessageNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Font;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XFetchValueActionBase
extends AnAction {
    @Nullable
    private static TreePath[] getSelectedNodes(DataContext dataContext) {
        XDebuggerTree tree = XDebuggerTree.getTree(dataContext);
        return tree == null ? null : tree.getSelectionPaths();
    }

    public void update(AnActionEvent e) {
        TreePath[] paths = XFetchValueActionBase.getSelectedNodes(e.getDataContext());
        if (paths != null) {
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                if (node instanceof XValueNodeImpl) {
                    if (!((XValueNodeImpl)node).isComputed()) continue;
                    e.getPresentation().setEnabled(true);
                    return;
                }
                if (!(node instanceof WatchMessageNode)) continue;
                e.getPresentation().setEnabled(true);
                return;
            }
        }
        e.getPresentation().setEnabled(false);
    }

    public void actionPerformed(AnActionEvent e) {
        TreePath[] paths = XFetchValueActionBase.getSelectedNodes(e.getDataContext());
        if (paths == null) {
            return;
        }
        ValueCollector valueCollector = new ValueCollector();
        for (TreePath path : paths) {
            Object node = path.getLastPathComponent();
            if (node instanceof XValueNodeImpl) {
                XValueNodeImpl valueNode = (XValueNodeImpl)node;
                XFullValueEvaluator fullValueEvaluator = valueNode.getFullValueEvaluator();
                if (fullValueEvaluator == null) {
                    valueCollector.add(StringUtil.notNullize((String)valueNode.getRawValue()));
                    continue;
                }
                XFetchValueActionBase.startFetchingValue(fullValueEvaluator, new CopyValueEvaluationCallback(valueNode, valueCollector));
                continue;
            }
            if (!(node instanceof WatchMessageNode)) continue;
            valueCollector.add(((WatchMessageNode)node).getExpression());
        }
        valueCollector.processed = true;
        valueCollector.finish(e.getProject());
    }

    protected abstract void handle(Project var1, String var2);

    private static void startFetchingValue(XFullValueEvaluator fullValueEvaluator, final CopyValueEvaluationCallback callback) {
        fullValueEvaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)callback);
        new Alarm().addRequest(new Runnable(){

            @Override
            public void run() {
                callback.showProgress();
            }
        }, 500);
    }

    private static final class CopyValueEvaluationCallback
    implements XFullValueEvaluator.XFullValueEvaluationCallback {
        private final XValueNodeImpl myNode;
        private final int myValueIndex;
        private final ValueCollector myValueCollector;
        private volatile boolean myEvaluated;
        private volatile boolean myCanceled;
        private final Semaphore mySemaphore;

        public CopyValueEvaluationCallback(@NotNull XValueNodeImpl node, ValueCollector valueCollector) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "<init>"));
            }
            this.myNode = node;
            this.myValueCollector = valueCollector;
            this.myValueIndex = valueCollector.acquire();
            this.mySemaphore = new Semaphore();
            this.mySemaphore.down();
        }

        public void evaluated(@NotNull String fullValue) {
            if (fullValue == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "evaluated"));
            }
            this.evaluationComplete(fullValue);
        }

        public void evaluated(@NotNull String fullValue, @Nullable Font font) {
            if (fullValue == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "evaluated"));
            }
            this.evaluated(fullValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "errorOccurred"));
            }
            try {
                String message = XDebuggerBundle.message((String)"load.value.task.error", (Object[])new Object[]{errorMessage});
                XDebugSessionImpl.NOTIFICATION_GROUP.createNotification(message, NotificationType.ERROR).notify(this.myNode.getTree().getProject());
            }
            finally {
                this.evaluationComplete(errorMessage);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void evaluationComplete(String value) {
            try {
                this.myEvaluated = true;
                this.mySemaphore.up();
            }
            finally {
                this.myValueCollector.evaluationComplete(this.myValueIndex, value, this.myNode.getTree().getProject());
            }
        }

        public boolean isObsolete() {
            return this.myCanceled;
        }

        public void showProgress() {
            if (this.myEvaluated || this.myNode.isObsolete()) {
                return;
            }
            new Task.Backgroundable(this.myNode.getTree().getProject(), XDebuggerBundle.message((String)"load.value.task.text", (Object[])new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback$1", "run"));
                    }
                    indicator.setIndeterminate(true);
                    int i = 0;
                    while (!CopyValueEvaluationCallback.this.myCanceled && !CopyValueEvaluationCallback.this.myEvaluated) {
                        indicator.checkCanceled();
                        indicator.setFraction((double)(i++ % 100) * 0.01);
                        CopyValueEvaluationCallback.this.mySemaphore.waitFor(300L);
                    }
                }

                public boolean shouldStartInBackground() {
                    return false;
                }

                public void onCancel() {
                    CopyValueEvaluationCallback.this.myCanceled = true;
                }
            }.queue();
        }
    }

    private final class ValueCollector {
        private final List<String> values = new SmartList();
        private volatile boolean processed;

        private ValueCollector() {
        }

        public void add(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector", "add"));
            }
            this.values.add(value);
        }

        public void finish(Project project) {
            if (this.processed && !this.values.contains(null) && !project.isDisposed()) {
                XFetchValueActionBase.this.handle(project, StringUtil.join(this.values, (String)"\n"));
            }
        }

        public int acquire() {
            int index = this.values.size();
            this.values.add(null);
            return index;
        }

        public void evaluationComplete(int index, @NotNull String value, Project project) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector", "evaluationComplete"));
            }
            this.values.set(index, value);
            this.finish(project);
        }
    }
}

