/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.TextTransferable;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRenderer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeSpeedSearch;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerTree
extends DnDAwareTree
implements DataProvider,
Disposable {
    private static final DataKey<XDebuggerTree> XDEBUGGER_TREE_KEY = DataKey.create((String)"xdebugger.tree");
    private static final Convertor<TreePath, String> SPEED_SEARCH_CONVERTER = new Convertor<TreePath, String>(){

        public String convert(TreePath o) {
            String text = null;
            if (o != null) {
                Object node = o.getLastPathComponent();
                if (node instanceof RestorableStateNode) {
                    text = ((RestorableStateNode)node).getName();
                } else if (node instanceof XDebuggerTreeNode) {
                    text = ((XDebuggerTreeNode)node).getText().toString();
                }
            }
            return StringUtil.notNullize(text);
        }
    };
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (!(c instanceof XDebuggerTree)) {
                return null;
            }
            XDebuggerTree tree = (XDebuggerTree)((Object)c);
            TreePath[] selectedPaths = tree.getSelectionPaths();
            if (selectedPaths == null || selectedPaths.length == 0) {
                return null;
            }
            StringBuilder plainBuf = new StringBuilder();
            StringBuilder htmlBuf = new StringBuilder();
            htmlBuf.append("<html>\n<body>\n<ul>\n");
            TextTransferable.ColoredStringBuilder coloredTextContainer = new TextTransferable.ColoredStringBuilder();
            for (TreePath path : selectedPaths) {
                htmlBuf.append("  <li>");
                Object node = path.getLastPathComponent();
                if (node != null) {
                    if (node instanceof XDebuggerTreeNode) {
                        ((XDebuggerTreeNode)node).appendToComponent(coloredTextContainer);
                        coloredTextContainer.appendTo(plainBuf, htmlBuf);
                    } else {
                        String text = node.toString();
                        plainBuf.append(text);
                        htmlBuf.append(text);
                    }
                }
                plainBuf.append('\n');
                htmlBuf.append("</li>\n");
            }
            plainBuf.setLength(plainBuf.length() - 1);
            htmlBuf.append("</ul>\n</body>\n</html>");
            return new TextTransferable(htmlBuf.toString(), plainBuf.toString());
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    };
    private final DefaultTreeModel myTreeModel;
    private final Project myProject;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private XSourcePosition mySourcePosition;
    private final List<XDebuggerTreeListener> myListeners;
    private final XValueMarkers<?, ?> myValueMarkers;

    public XDebuggerTree(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, final @NotNull String popupActionGroupId, @Nullable XValueMarkers<?, ?> valueMarkers) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "<init>"));
        }
        if (popupActionGroupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myValueMarkers = valueMarkers;
        this.myProject = project;
        this.myEditorsProvider = editorsProvider;
        this.mySourcePosition = sourcePosition;
        this.myTreeModel = new DefaultTreeModel(null);
        this.setModel(this.myTreeModel);
        this.setCellRenderer((TreeCellRenderer)((Object)new XDebuggerTreeRenderer()));
        new TreeLinkMouseListener(new XDebuggerTreeRenderer()){

            protected void handleTagClick(@Nullable Object tag, @NotNull MouseEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$3", "handleTagClick"));
                }
                if (tag instanceof XDebuggerTreeNodeHyperlink) {
                    ((XDebuggerTreeNodeHyperlink)tag).onClick(event);
                }
            }
        }.installOn((Component)((Object)this));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                XDebuggerTree.this.expandIfEllipsis();
                return true;
            }
        }.installOn((Component)((Object)this));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10 || key == 32 || key == 39) {
                    XDebuggerTree.this.expandIfEllipsis();
                }
            }
        });
        if (Boolean.valueOf(System.getProperty("xdebugger.variablesView.rss")).booleanValue()) {
            new XDebuggerTreeSpeedSearch(this, SPEED_SEARCH_CONVERTER);
        } else {
            new TreeSpeedSearch(this, SPEED_SEARCH_CONVERTER);
        }
        final ActionManager actionManager = ActionManager.getInstance();
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group = (ActionGroup)actionManager.getAction(popupActionGroupId);
                actionManager.createActionPopupMenu("unknown", group).getComponent().show(comp, x, y);
            }
        });
        this.registerShortcuts();
        this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
    }

    private void expandIfEllipsis() {
        TreeNode parent;
        MessageTreeNode node;
        MessageTreeNode[] treeNodes = (MessageTreeNode[])this.getSelectedNodes(MessageTreeNode.class, null);
        if (treeNodes.length == 1 && (node = treeNodes[0]).isEllipsis() && (parent = node.getParent()) instanceof XValueContainerNode) {
            ((XValueContainerNode)parent).startComputingChildren();
        }
    }

    public void addTreeListener(@NotNull XDebuggerTreeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "addTreeListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeTreeListener(@NotNull XDebuggerTreeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "removeTreeListener"));
        }
        this.myListeners.remove(listener);
    }

    public void setRoot(XDebuggerTreeNode root, boolean rootVisible) {
        this.setRootVisible(rootVisible);
        this.myTreeModel.setRoot(root);
    }

    public XDebuggerTreeNode getRoot() {
        return (XDebuggerTreeNode)this.myTreeModel.getRoot();
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
        this.mySourcePosition = sourcePosition;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = this.myEditorsProvider;
        if (xDebuggerEditorsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "getEditorsProvider"));
        }
        return xDebuggerEditorsProvider;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "getProject"));
        }
        return project;
    }

    @Nullable
    public XValueMarkers<?, ?> getValueMarkers() {
        return this.myValueMarkers;
    }

    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (XDEBUGGER_TREE_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    public void rebuildAndRestore(XDebuggerTreeState treeState) {
        Object rootNode = this.myTreeModel.getRoot();
        if (rootNode instanceof XDebuggerTreeNode) {
            ((XDebuggerTreeNode)rootNode).clearChildren();
            treeState.restoreState(this);
            this.repaint();
        }
    }

    public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<XValueContainerNode<?>> children, boolean last) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "childrenLoaded"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "childrenLoaded"));
        }
        for (XDebuggerTreeListener listener : this.myListeners) {
            listener.childrenLoaded(node, children, last);
        }
    }

    public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "nodeLoaded"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree", "nodeLoaded"));
        }
        for (XDebuggerTreeListener listener : this.myListeners) {
            listener.nodeLoaded(node, name);
        }
    }

    public void markNodesObsolete() {
        Object root = this.myTreeModel.getRoot();
        if (root instanceof XValueContainerNode) {
            XDebuggerTree.markNodesObsolete((XValueContainerNode)root);
        }
    }

    public void dispose() {
        ActionManager actionManager = ActionManager.getInstance();
        actionManager.getAction("XDebugger.SetValue").unregisterCustomShortcutSet((JComponent)((Object)this));
        actionManager.getAction("XDebugger.CopyValue").unregisterCustomShortcutSet((JComponent)((Object)this));
        actionManager.getAction("XDebugger.JumpToSource").unregisterCustomShortcutSet((JComponent)((Object)this));
        actionManager.getAction("XDebugger.JumpToTypeSource").unregisterCustomShortcutSet((JComponent)((Object)this));
        actionManager.getAction("Debugger.MarkObject").unregisterCustomShortcutSet((JComponent)((Object)this));
    }

    private void registerShortcuts() {
        ActionManager actionManager = ActionManager.getInstance();
        actionManager.getAction("XDebugger.SetValue").registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), (JComponent)((Object)this));
        actionManager.getAction("XDebugger.CopyValue").registerCustomShortcutSet(CommonShortcuts.getCopy(), (JComponent)((Object)this));
        actionManager.getAction("XDebugger.JumpToSource").registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)((Object)this));
        Shortcut[] editTypeShortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("Debugger.EditTypeSource");
        actionManager.getAction("XDebugger.JumpToTypeSource").registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(editTypeShortcuts), (JComponent)((Object)this));
        actionManager.getAction("Debugger.MarkObject").registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("ToggleBookmark")), (JComponent)((Object)this));
    }

    private static void markNodesObsolete(XValueContainerNode<?> node) {
        node.setObsolete();
        List<XValueContainerNode<?>> loadedChildren = node.getLoadedChildren();
        if (loadedChildren != null) {
            for (XValueContainerNode<?> child : loadedChildren) {
                XDebuggerTree.markNodesObsolete(child);
            }
        }
    }

    @Nullable
    public static XDebuggerTree getTree(AnActionEvent e) {
        return (XDebuggerTree)((Object)e.getData(XDEBUGGER_TREE_KEY));
    }

    @Nullable
    public static XDebuggerTree getTree(DataContext context) {
        return (XDebuggerTree)((Object)XDEBUGGER_TREE_KEY.getData(context));
    }
}

