/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public abstract class ValueMarkerPresentationDialogBase
extends DialogWrapper {
    private static final Color DEFAULT_COLOR = JBColor.RED;
    private SimpleColoredComponent myColorSample;
    private Color myColor;
    private JPanel myMainPanel;
    private JTextField myLabelField;
    private FixedSizeButton myChooseColorButton;
    private JPanel mySamplePanel;

    public ValueMarkerPresentationDialogBase(@Nullable String defaultText) {
        super(true);
        this.$$$setupUI$$$();
        this.setTitle("Select Object Label");
        this.setModal(true);
        this.myLabelField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ValueMarkerPresentationDialogBase.this.updateLabelSample();
            }
        });
        this.myChooseColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = ColorChooser.chooseColor((Component)ValueMarkerPresentationDialogBase.this.myColorSample, (String)"Choose Label Color", (Color)ValueMarkerPresentationDialogBase.this.myColor);
                if (color != null) {
                    ValueMarkerPresentationDialogBase.this.myColor = color;
                    ValueMarkerPresentationDialogBase.this.updateLabelSample();
                }
            }
        });
        this.myColor = DEFAULT_COLOR;
        if (defaultText != null) {
            this.myLabelField.setText(defaultText.trim());
            this.updateLabelSample();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLabelField;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void updateLabelSample() {
        this.myColorSample.clear();
        SimpleTextAttributes attributes = new SimpleTextAttributes(1, this.myColor);
        this.myColorSample.append(this.myLabelField.getText().trim(), attributes);
    }

    @Nullable
    public ValueMarkup getConfiguredMarkup() {
        String text = this.myLabelField.getText().trim();
        return text.isEmpty() ? null : new ValueMarkup(text, this.myColor, null);
    }

    private void createUIComponents() {
        this.myColorSample = new SimpleColoredComponent();
        this.mySamplePanel = new JPanel(new BorderLayout());
        this.mySamplePanel.setBorder(BorderFactory.createEtchedBorder());
        this.mySamplePanel.add("Center", (Component)this.myColorSample);
        this.myChooseColorButton = new FixedSizeButton((JComponent)this.mySamplePanel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Label:");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLabelField = jTextField = new JTextField();
        jTextField.setColumns(30);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Preview: ");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.mySamplePanel;
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 3, null, new Dimension(406, 0), null));
        FixedSizeButton fixedSizeButton = this.myChooseColorButton;
        jPanel.add((Component)fixedSizeButton, new GridConstraints(1, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

