/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerMultilineEditor
extends XDebuggerEditorBase {
    private final EditorTextField myEditorTextField;

    public XDebuggerMultilineEditor(Project project, XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/xdebugger/impl/ui/XDebuggerMultilineEditor", "<init>"));
        }
        super(project, debuggerEditorsProvider, EvaluationMode.CODE_FRAGMENT, historyId, sourcePosition);
        this.myEditorTextField = new EditorTextField(this.createDocument(text), project, debuggerEditorsProvider.getFileType()){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setVerticalScrollbarVisible(true);
                return editor;
            }

            @Override
            protected boolean isOneLineMode() {
                return false;
            }
        };
    }

    @Override
    public JComponent getComponent() {
        return this.myEditorTextField;
    }

    @Override
    protected void doSetText(String text) {
        this.myEditorTextField.setText(text);
    }

    @Override
    public String getText() {
        return this.myEditorTextField.getText();
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        Editor editor = this.myEditorTextField.getEditor();
        return editor != null ? editor.getContentComponent() : null;
    }

    @Override
    public void selectAll() {
        this.myEditorTextField.selectAll();
    }
}

