/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.DebuggerLogConsoleManager;
import com.intellij.diagnostic.logging.LogConsoleManagerBase;
import com.intellij.diagnostic.logging.LogFilesManager;
import com.intellij.diagnostic.logging.OutputFileUtil;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AppIcon;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebuggerBundle;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerSessionTabBase
extends LogConsoleManagerBase
implements DebuggerLogConsoleManager {
    @NotNull
    private final LogFilesManager myManager;
    @NotNull
    final String mySessionName;
    @NotNull
    protected final RunnerLayoutUi myUi;
    protected ExecutionConsole myConsole;
    protected RunContentDescriptor myRunContentDescriptor;

    public DebuggerSessionTabBase(@NotNull Project project, @NotNull String runnerId, @NotNull String sessionName, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/DebuggerSessionTabBase", "<init>"));
        }
        if (runnerId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/ui/DebuggerSessionTabBase", "<init>"));
        }
        if (sessionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/ui/DebuggerSessionTabBase", "<init>"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/ui/DebuggerSessionTabBase", "<init>"));
        }
        super(project, searchScope);
        Disposer.register((Disposable)project, (Disposable)this);
        this.myManager = new LogFilesManager(project, this, this);
        this.mySessionName = sessionName;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create(runnerId, XDebuggerBundle.message((String)"xdebugger.default.content.title", (Object[])new Object[0]), sessionName, (Disposable)this);
        this.myUi.getDefaults().initTabDefaults(0, XDebuggerBundle.message((String)"xdebugger.debugger.tab.title", (Object[])new Object[0]), null).initFocusContent("FrameContent", "breakpoint").initFocusContent("ConsoleContent", "startup", (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce(false));
    }

    protected static ActionGroup getCustomizedActionGroup(String id) {
        return (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(id);
    }

    public abstract RunContentDescriptor getRunContentDescriptor();

    @Override
    public ProcessHandler getProcessHandler() {
        return this.getRunContentDescriptor().getProcessHandler();
    }

    @Override
    protected Content createLogContent(AdditionalTabComponent tabComponent, String id, Icon icon) {
        Content result = super.createLogContent(tabComponent, id, icon);
        result.setCloseable(false);
        result.setDescription(tabComponent.getTooltip());
        return result;
    }

    @Override
    protected Icon getDefaultIcon() {
        return AllIcons.FileTypes.Text;
    }

    @Override
    @NotNull
    public RunnerLayoutUi getUi() {
        RunnerLayoutUi runnerLayoutUi = this.myUi;
        if (runnerLayoutUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/DebuggerSessionTabBase", "getUi"));
        }
        return runnerLayoutUi;
    }

    protected void registerFileMatcher(RunProfile runConfiguration) {
        if (runConfiguration instanceof RunConfigurationBase) {
            this.myManager.registerFileMatcher((RunConfigurationBase)runConfiguration);
        }
    }

    protected void initLogConsoles(RunProfile runConfiguration, ProcessHandler processHandler, ExecutionConsole console) {
        if (runConfiguration instanceof RunConfigurationBase) {
            this.myManager.initLogConsoles((RunConfigurationBase)runConfiguration, processHandler);
            OutputFileUtil.attachDumpListener((RunConfigurationBase)runConfiguration, processHandler, console);
        }
    }

    protected LogFilesManager getLogManager() {
        return this.myManager;
    }

    protected void attachNotificationTo(final Content content) {
        if (this.myConsole instanceof ObservableConsoleView) {
            ObservableConsoleView observable = (ObservableConsoleView)this.myConsole;
            observable.addChangeListener(new ObservableConsoleView.ChangeListener(){

                public void contentAdded(Collection<ConsoleViewContentType> types) {
                    if (types.contains(ConsoleViewContentType.ERROR_OUTPUT) || types.contains(ConsoleViewContentType.NORMAL_OUTPUT)) {
                        content.fireAlert();
                    }
                }
            }, (Disposable)content);
            RunProfile profile = this.getRunProfile();
            if (profile instanceof RunConfigurationBase && !ApplicationManager.getApplication().isUnitTestMode()) {
                RunConfigurationBase runConfigurationBase = (RunConfigurationBase)profile;
                observable.addChangeListener((ObservableConsoleView.ChangeListener)new RunContentBuilder.ConsoleToFrontListener(runConfigurationBase, this.getProject(), DefaultDebugExecutor.getDebugExecutorInstance(), this.myRunContentDescriptor, this.getUi()), (Disposable)content);
            }
        }
    }

    @Nullable
    protected RunProfile getRunProfile() {
        ExecutionEnvironment environment = this.getEnvironment();
        return environment != null ? environment.getRunProfile() : null;
    }

    public void toFront() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ExecutionManager.getInstance((Project)this.getProject()).getContentManager().toFrontRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), this.myRunContentDescriptor);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean focusWnd = Registry.is((String)"debugger.mayBringFrameToFrontOnBreakpoint");
                    ProjectUtil.focusProjectWindow(DebuggerSessionTabBase.this.getProject(), focusWnd);
                    if (!focusWnd) {
                        AppIcon.getInstance().requestAttention(DebuggerSessionTabBase.this.getProject(), true);
                    }
                }
            });
        }
    }
}

