/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XStackFrameNode;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XVariablesViewBase
implements Disposable {
    protected final XDebuggerTreePanel myDebuggerTreePanel;
    private XDebuggerTreeState myTreeState;
    private Object myFrameEqualityObject;
    private XDebuggerTreeRestorer myTreeRestorer;

    protected XVariablesViewBase(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XValueMarkers<?, ?> markers) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XVariablesViewBase", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/frame/XVariablesViewBase", "<init>"));
        }
        this.myDebuggerTreePanel = new XDebuggerTreePanel(project, editorsProvider, this, null, "XDebugger.Variables.Tree.Popup", markers);
        this.myDebuggerTreePanel.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.variables.not.available", (Object[])new Object[0]));
        DnDManager.getInstance().registerSource((DnDSource)this.myDebuggerTreePanel, (JComponent)((Object)this.myDebuggerTreePanel.getTree()));
    }

    protected void buildTreeAndRestoreState(@NotNull XStackFrame stackFrame) {
        if (stackFrame == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XVariablesViewBase", "buildTreeAndRestoreState"));
        }
        XDebuggerTree tree = this.myDebuggerTreePanel.getTree();
        tree.setSourcePosition(stackFrame.getSourcePosition());
        tree.setRoot(new XStackFrameNode(tree, stackFrame), false);
        Object newEqualityObject = stackFrame.getEqualityObject();
        if (this.myFrameEqualityObject != null && newEqualityObject != null && this.myFrameEqualityObject.equals(newEqualityObject) && this.myTreeState != null) {
            this.disposeTreeRestorer();
            this.myTreeRestorer = this.myTreeState.restoreState(tree);
        }
    }

    protected void saveCurrentTreeState(@Nullable XStackFrame stackFrame) {
        this.disposeTreeRestorer();
        this.myFrameEqualityObject = stackFrame != null ? stackFrame.getEqualityObject() : null;
        this.myTreeState = XDebuggerTreeState.saveState(this.myDebuggerTreePanel.getTree());
    }

    private void disposeTreeRestorer() {
        if (this.myTreeRestorer != null) {
            this.myTreeRestorer.dispose();
            this.myTreeRestorer = null;
        }
    }

    public XDebuggerTree getTree() {
        return this.myDebuggerTreePanel.getTree();
    }

    public JComponent getPanel() {
        return this.myDebuggerTreePanel.getMainPanel();
    }

    public void dispose() {
        this.disposeTreeRestorer();
        DnDManager.getInstance().unregisterSource((DnDSource)this.myDebuggerTreePanel, (JComponent)((Object)this.myDebuggerTreePanel.getTree()));
    }
}

