/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesViewBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import org.jetbrains.annotations.NotNull;

public class XVariablesView
extends XVariablesViewBase
implements XDebugView {
    @NotNull
    private final XDebugSession mySession;

    public XVariablesView(@NotNull XDebugSession session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XVariablesView", "<init>"));
        }
        super(session.getProject(), session.getDebugProcess().getEditorsProvider(), ((XDebugSessionImpl)session).getValueMarkers());
        this.mySession = session;
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XVariablesView", "processSessionEvent"));
        }
        XStackFrame stackFrame = this.mySession.getCurrentStackFrame();
        XDebuggerTree tree = this.getTree();
        if (event == XDebugView.SessionEvent.BEFORE_RESUME || event == XDebugView.SessionEvent.SETTINGS_CHANGED) {
            this.saveCurrentTreeState(stackFrame);
            if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
                return;
            }
        }
        tree.markNodesObsolete();
        if (stackFrame != null) {
            this.buildTreeAndRestoreState(stackFrame);
        } else {
            MessageTreeNode node;
            tree.setSourcePosition(null);
            if (!this.mySession.isStopped() && this.mySession.isPaused()) {
                node = MessageTreeNode.createInfoMessage(tree, "Frame is not available");
            } else {
                XDebugProcess debugProcess = this.mySession.getDebugProcess();
                node = MessageTreeNode.createInfoMessage(tree, debugProcess.getCurrentStateMessage(), debugProcess.getCurrentStateHyperlinkListener());
            }
            tree.setRoot(node, true);
        }
    }
}

