/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final WatchesRootNode myRootNode;
    private final XWatchesView myWatchesView;
    @Nullable
    private final WatchNode myOldNode;

    public WatchInplaceEditor(@NotNull WatchesRootNode rootNode, @NotNull XDebugSession session, XWatchesView watchesView, WatchNode node, @NonNls String historyId, @Nullable WatchNode oldNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/WatchInplaceEditor", "<init>"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/frame/WatchInplaceEditor", "<init>"));
        }
        super((XDebuggerTreeNode)((Object)node), historyId);
        this.myRootNode = rootNode;
        this.myWatchesView = watchesView;
        this.myOldNode = oldNode;
        this.myExpressionEditor.setText(oldNode != null ? oldNode.getExpression() : "");
        new WatchEditorSessionListener(session).install();
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        return this.myExpressionEditor.getComponent();
    }

    @Override
    public void cancelEditing() {
        if (!this.isShown()) {
            return;
        }
        super.cancelEditing();
        int index = this.myRootNode.removeChildNode(this.getNode());
        if (this.myOldNode != null && index != -1) {
            this.myWatchesView.addWatchExpression(this.myOldNode.getExpression(), index, false);
        }
    }

    @Override
    public void doOKAction() {
        String expression = this.myExpressionEditor.getText();
        this.myExpressionEditor.saveTextInHistory();
        super.doOKAction();
        int index = this.myRootNode.removeChildNode(this.getNode());
        if (!StringUtil.isEmpty((String)expression) && index != -1) {
            this.myWatchesView.addWatchExpression(expression, index, false);
        }
    }

    private class WatchEditorSessionListener
    extends XDebugSessionAdapter {
        private final XDebugSession mySession;

        public WatchEditorSessionListener(XDebugSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/WatchInplaceEditor$WatchEditorSessionListener", "<init>"));
            }
            this.mySession = session;
        }

        public void install() {
            this.mySession.addSessionListener((XDebugSessionListener)this);
        }

        private void cancel() {
            this.mySession.removeSessionListener((XDebugSessionListener)this);
            AppUIUtil.invokeOnEdt(new Runnable(){

                @Override
                public void run() {
                    WatchInplaceEditor.this.cancelEditing();
                }
            });
        }

        public void sessionPaused() {
            this.cancel();
        }

        public void beforeSessionResume() {
            this.cancel();
        }

        public void sessionResumed() {
            this.cancel();
        }

        public void sessionStopped() {
            this.cancel();
        }
    }
}

