/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.evaluate.CodeFragmentInputComponent;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.evaluate.ExpressionInputComponent;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.nodes.EvaluatingExpressionRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerEvaluationDialog
extends DialogWrapper {
    private final JPanel myMainPanel;
    private final JPanel myResultPanel;
    private final XDebuggerTreePanel myTreePanel;
    private EvaluationInputComponent myInputComponent;
    private final XDebugSession mySession;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private EvaluationMode myMode;
    private final XSourcePosition mySourcePosition;
    private final SwitchModeAction mySwitchModeAction;
    private final boolean myIsCodeFragmentEvaluationSupported;

    public XDebuggerEvaluationDialog(@NotNull XDebugSession session, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull XDebuggerEvaluator evaluator, @NotNull String text, @Nullable XSourcePosition sourcePosition) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "<init>"));
        }
        super(session.getProject(), true);
        this.mySession = session;
        this.myEditorsProvider = editorsProvider;
        this.mySourcePosition = sourcePosition;
        this.setModal(false);
        this.setOKButtonText(XDebuggerBundle.message((String)"xdebugger.button.evaluate", (Object[])new Object[0]));
        this.setCancelButtonText(XDebuggerBundle.message((String)"xdebugger.evaluate.dialog.close", (Object[])new Object[0]));
        this.mySession.addSessionListener((XDebugSessionListener)new XDebugSessionAdapter(){

            public void sessionStopped() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        XDebuggerEvaluationDialog.this.close(1);
                    }
                });
            }
        }, this.myDisposable);
        this.myTreePanel = new XDebuggerTreePanel(session.getProject(), editorsProvider, this.myDisposable, sourcePosition, "XDebugger.Evaluation.Dialog.Tree.Popup", ((XDebugSessionImpl)session).getValueMarkers());
        this.myResultPanel = new JPanel(new BorderLayout());
        this.myResultPanel.add((Component)new JLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.label.result", (Object[])new Object[0])), "North");
        this.myResultPanel.add((Component)this.myTreePanel.getMainPanel(), "Center");
        this.myMainPanel = new JPanel(new BorderLayout());
        this.mySwitchModeAction = new SwitchModeAction();
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                XDebuggerEvaluationDialog.this.doOKAction();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 128)), (JComponent)this.getRootPane(), this.myDisposable);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                IdeFocusManager.getInstance((Project)XDebuggerEvaluationDialog.this.mySession.getProject()).requestFocus((Component)((Object)XDebuggerEvaluationDialog.this.myTreePanel.getTree()), true);
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(82, 512)), (JComponent)this.getRootPane(), this.myDisposable);
        EvaluationMode mode = EvaluationMode.EXPRESSION;
        this.myIsCodeFragmentEvaluationSupported = evaluator.isCodeFragmentEvaluationSupported();
        if (text.indexOf(10) != -1) {
            if (this.myIsCodeFragmentEvaluationSupported) {
                mode = EvaluationMode.CODE_FRAGMENT;
            } else {
                text = StringUtil.replace((String)text, (String)"\n", (String)" ");
            }
        }
        this.switchToMode(mode, text);
        this.init();
    }

    protected void doOKAction() {
        this.evaluate();
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myIsCodeFragmentEvaluationSupported) {
            Action[] actionArray = new Action[]{this.getOKAction(), this.mySwitchModeAction, this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "createActions"));
        }
        return actionArray;
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        if (action == this.mySwitchModeAction) {
            int width1 = new JButton((String)XDebuggerEvaluationDialog.getSwitchButtonText((EvaluationMode)EvaluationMode.EXPRESSION)).getPreferredSize().width;
            int width2 = new JButton((String)XDebuggerEvaluationDialog.getSwitchButtonText((EvaluationMode)EvaluationMode.CODE_FRAGMENT)).getPreferredSize().width;
            Dimension size = new Dimension(Math.max(width1, width2), button.getPreferredSize().height);
            button.setMinimumSize(size);
            button.setPreferredSize(size);
        }
        return button;
    }

    public String getExpression() {
        return this.myInputComponent.getInputEditor().getText();
    }

    private static String getSwitchButtonText(EvaluationMode mode) {
        return mode != EvaluationMode.EXPRESSION ? XDebuggerBundle.message((String)"button.text.expression.mode", (Object[])new Object[0]) : XDebuggerBundle.message((String)"button.text.code.fragment.mode", (Object[])new Object[0]);
    }

    private void switchToMode(EvaluationMode mode, String text) {
        if (this.myMode == mode) {
            return;
        }
        this.myMode = mode;
        this.myInputComponent = this.createInputComponent(mode, text);
        this.myMainPanel.removeAll();
        this.myInputComponent.addComponent(this.myMainPanel, this.myResultPanel);
        this.setTitle(this.myInputComponent.getTitle());
        this.mySwitchModeAction.putValue("Name", XDebuggerEvaluationDialog.getSwitchButtonText(mode));
        JComponent preferredFocusedComponent = this.myInputComponent.getInputEditor().getPreferredFocusedComponent();
        if (preferredFocusedComponent != null) {
            IdeFocusManager.getInstance((Project)this.mySession.getProject()).requestFocus((Component)preferredFocusedComponent, true);
        }
    }

    private EvaluationInputComponent createInputComponent(EvaluationMode mode, String text) {
        Project project = this.mySession.getProject();
        if (mode == EvaluationMode.EXPRESSION) {
            return new ExpressionInputComponent(project, this.myEditorsProvider, this.mySourcePosition, text);
        }
        return new CodeFragmentInputComponent(project, this.myEditorsProvider, this.mySourcePosition, text, this.myDisposable);
    }

    private void evaluate() {
        XDebuggerTree tree = this.myTreePanel.getTree();
        XDebuggerTreeNode root = tree.getRoot();
        if (root instanceof EvaluatingExpressionRootNode) {
            root.clearChildren();
        } else {
            tree.setRoot(new EvaluatingExpressionRootNode(this, tree), false);
        }
        this.myResultPanel.invalidate();
        this.myInputComponent.getInputEditor().selectAll();
    }

    protected String getDimensionServiceKey() {
        return "#xdebugger.evaluate";
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public void startEvaluation(@NotNull XDebuggerEvaluator.XEvaluationCallback evaluationCallback) {
        if (evaluationCallback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog", "startEvaluation"));
        }
        XDebuggerEditorBase inputEditor = this.myInputComponent.getInputEditor();
        inputEditor.saveTextInHistory();
        String expression = inputEditor.getText();
        XDebuggerEvaluator evaluator = this.mySession.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            evaluationCallback.errorOccurred(XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]));
        } else {
            evaluator.evaluate(expression, evaluationCallback, null, inputEditor.getMode());
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myInputComponent.getInputEditor().getPreferredFocusedComponent();
    }

    private class SwitchModeAction
    extends AbstractAction {
        private SwitchModeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = XDebuggerEvaluationDialog.this.myInputComponent.getInputEditor().getText();
            if (XDebuggerEvaluationDialog.this.myMode == EvaluationMode.EXPRESSION) {
                XDebuggerEvaluationDialog.this.switchToMode(EvaluationMode.CODE_FRAGMENT, text);
            } else {
                if (text.indexOf(10) != -1) {
                    text = "";
                }
                XDebuggerEvaluationDialog.this.switchToMode(EvaluationMode.EXPRESSION, text);
            }
        }
    }
}

