/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionInputComponent
extends EvaluationInputComponent {
    private final XDebuggerExpressionComboBox myExpressionComboBox;
    private final JPanel myMainPanel;

    public ExpressionInputComponent(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, @Nullable String expression) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent", "<init>"));
        }
        super(XDebuggerBundle.message((String)"xdebugger.dialog.title.evaluate.expression", (Object[])new Object[0]));
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)new JLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.label.expression", (Object[])new Object[0])), "West");
        this.myExpressionComboBox = new XDebuggerExpressionComboBox(project, editorsProvider, "evaluateExpression", sourcePosition);
        this.myExpressionComboBox.getComboBox().setMinimumAndPreferredWidth(250);
        this.myMainPanel.add((Component)this.myExpressionComboBox.getComponent(), "Center");
        if (expression != null) {
            this.myExpressionComboBox.setText(expression);
        }
        this.myExpressionComboBox.selectAll();
    }

    @Override
    public void addComponent(JPanel contentPanel, JPanel resultPanel) {
        contentPanel.add((Component)resultPanel, "Center");
        contentPanel.add((Component)this.myMainPanel, "North");
    }

    @Override
    protected XDebuggerEditorBase getInputEditor() {
        return this.myExpressionComboBox;
    }
}

