/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.XDebuggerMultilineEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFragmentInputComponent
extends EvaluationInputComponent {
    private final XDebuggerMultilineEditor myMultilineEditor;
    private final JPanel myMainPanel;

    public CodeFragmentInputComponent(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, @Nullable String statements, Disposable parentDisposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/CodeFragmentInputComponent", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/evaluate/CodeFragmentInputComponent", "<init>"));
        }
        super(XDebuggerBundle.message((String)"dialog.title.evaluate.code.fragment", (Object[])new Object[0]));
        this.myMultilineEditor = new XDebuggerMultilineEditor(project, editorsProvider, "evaluateCodeFragment", sourcePosition, statements != null ? statements : "");
        this.myMainPanel = new JPanel(new BorderLayout());
        JPanel editorPanel = new JPanel(new BorderLayout());
        editorPanel.add((Component)this.myMultilineEditor.getComponent(), "Center");
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new HistoryNavigationAction(false, "PreviousOccurence", parentDisposable));
        group.add((AnAction)new HistoryNavigationAction(true, "NextOccurence", parentDisposable));
        editorPanel.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false).getComponent(), "East");
        this.myMainPanel.add((Component)new JLabel(XDebuggerBundle.message((String)"xdebugger.label.text.code.fragment", (Object[])new Object[0])), "North");
        this.myMainPanel.add((Component)editorPanel, "Center");
    }

    @Override
    protected XDebuggerEditorBase getInputEditor() {
        return this.myMultilineEditor;
    }

    @Override
    public void addComponent(JPanel contentPanel, JPanel resultPanel) {
        Splitter splitter = new Splitter(true, 0.3f, 0.2f, 0.7f);
        contentPanel.add((Component)splitter, "Center");
        splitter.setFirstComponent((JComponent)this.myMainPanel);
        splitter.setSecondComponent((JComponent)resultPanel);
    }

    private class HistoryNavigationAction
    extends AnAction {
        private final boolean myForward;

        public HistoryNavigationAction(boolean forward, String actionId, Disposable parentDisposable) {
            this.myForward = forward;
            AnAction action = ActionManager.getInstance().getAction(actionId);
            this.copyFrom(action);
            this.registerCustomShortcutSet(action.getShortcutSet(), CodeFragmentInputComponent.this.myMainPanel, parentDisposable);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.myForward ? CodeFragmentInputComponent.this.myMultilineEditor.canGoForward() : CodeFragmentInputComponent.this.myMultilineEditor.canGoBackward());
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myForward) {
                CodeFragmentInputComponent.this.myMultilineEditor.goForward();
            } else {
                CodeFragmentInputComponent.this.myMultilineEditor.goBackward();
            }
        }
    }
}

