/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsTreeCellRenderer;

public class BreakpointsCheckboxTree
extends CheckboxTree {
    private Delegate myDelegate = null;

    protected void nodeStateWillChange(CheckedTreeNode node) {
        super.nodeStateWillChange(node);
        if (this.myDelegate != null) {
            this.myDelegate.nodeStateWillChange(node);
        }
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
        super.onNodeStateChanged(node);
        if (this.myDelegate != null) {
            this.myDelegate.nodeStateDidChange(node);
        }
    }

    public void setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
    }

    public BreakpointsCheckboxTree(Project project, BreakpointItemsTreeController model) {
        super(new BreakpointsTreeCellRenderer.BreakpointsCheckboxTreeCellRenderer(project), model.getRoot());
        this.setHorizontalAutoScrollingEnabled(false);
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof BreakpointItemNode) {
            String displayText;
            BreakpointItem breakpointItem = ((BreakpointItemNode)((Object)value)).getBreakpointItem();
            String string = displayText = breakpointItem != null ? breakpointItem.getDisplayText() : null;
            if (!StringUtil.isEmptyOrSpaces((String)displayText)) {
                return displayText;
            }
        }
        return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
    }

    static interface Delegate {
        public void nodeStateDidChange(CheckedTreeNode var1);

        public void nodeStateWillChange(CheckedTreeNode var1);
    }
}

