/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.grouping;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroup;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointFileGroupingRule<B>
extends XBreakpointGroupingRule<B, XBreakpointFileGroup> {
    public XBreakpointFileGroupingRule() {
        super("by-file", XDebuggerBundle.message((String)"rule.name.group.by.file", (Object[])new Object[0]));
    }

    public int getPriority() {
        return 600;
    }

    public XBreakpointFileGroup getGroup(@NotNull B breakpoint, @NotNull Collection<XBreakpointFileGroup> groups) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/ui/grouping/XBreakpointFileGroupingRule", "getGroup"));
        }
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/breakpoints/ui/grouping/XBreakpointFileGroupingRule", "getGroup"));
        }
        if (!(breakpoint instanceof XLineBreakpoint)) {
            return null;
        }
        XSourcePosition position = ((XLineBreakpoint)breakpoint).getSourcePosition();
        if (position == null) {
            return null;
        }
        VirtualFile file = position.getFile();
        for (XBreakpointFileGroup group : groups) {
            if (!group.getFile().equals(file)) continue;
            return group;
        }
        return new XBreakpointFileGroup(file);
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }
}

