/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DefaultConditionComboBoxPanel<B extends XBreakpoint<?>>
extends XBreakpointCustomPropertiesPanel<B> {
    public static final String HISTORY_KEY = "breakpointCondition";
    private XDebuggerExpressionComboBox myConditionComboBox;

    public DefaultConditionComboBoxPanel(Project project, XDebuggerEditorsProvider debuggerEditorsProvider, XSourcePosition sourcePosition) {
        this.myConditionComboBox = new XDebuggerExpressionComboBox(project, debuggerEditorsProvider, HISTORY_KEY, sourcePosition);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myConditionComboBox.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/ui/DefaultConditionComboBoxPanel", "getComponent"));
        }
        return jComponent;
    }

    public void saveTo(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/ui/DefaultConditionComboBoxPanel", "saveTo"));
        }
        String condition = StringUtil.nullize((String)this.myConditionComboBox.getText(), (boolean)true);
        breakpoint.setCondition(condition);
        if (condition != null) {
            this.myConditionComboBox.saveTextInHistory();
        }
    }

    public void loadFrom(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/ui/DefaultConditionComboBoxPanel", "loadFrom"));
        }
        this.myConditionComboBox.setText(StringUtil.notNullize((String)breakpoint.getCondition()));
    }
}

