/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.actions.ExpandRegionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointUtil {
    private XBreakpointUtil() {
    }

    public static <B extends XBreakpoint<?>> String getShortText(B breakpoint) {
        return XBreakpointUtil.getType(breakpoint).getShortText(breakpoint);
    }

    public static <B extends XBreakpoint<?>> String getDisplayText(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "getDisplayText"));
        }
        return XBreakpointUtil.getType(breakpoint).getDisplayText(breakpoint);
    }

    public static <B extends XBreakpoint<?>> XBreakpointType<B, ?> getType(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "getType"));
        }
        return breakpoint.getType();
    }

    @Nullable
    public static XBreakpointType<?, ?> findType(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "findType"));
        }
        for (XBreakpointType<?, ?> breakpointType : XBreakpointUtil.getBreakpointTypes()) {
            if (!id.equals(breakpointType.getId())) continue;
            return breakpointType;
        }
        return null;
    }

    public static XBreakpointType<?, ?>[] getBreakpointTypes() {
        return (XBreakpointType[])XBreakpointType.EXTENSION_POINT_NAME.getExtensions();
    }

    @NotNull
    public static Pair<GutterIconRenderer, Object> findSelectedBreakpoint(@NotNull Project project, @NotNull Editor editor) {
        DebuggerSupport[] debuggerSupports;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "findSelectedBreakpoint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "findSelectedBreakpoint"));
        }
        int offset = editor.getCaretModel().getOffset();
        Document editorDocument = editor.getDocument();
        for (DebuggerSupport debuggerSupport : debuggerSupports = DebuggerSupport.getDebuggerSupports()) {
            Object breakpoint;
            BreakpointPanelProvider<?> provider = debuggerSupport.getBreakpointPanelProvider();
            int textLength = editor.getDocument().getTextLength();
            if (offset > textLength) {
                offset = textLength;
            }
            if ((breakpoint = provider.findBreakpoint(project, editorDocument, offset)) == null) continue;
            GutterIconRenderer iconRenderer = provider.getBreakpointGutterIconRenderer(breakpoint);
            Pair pair = Pair.create((Object)iconRenderer, breakpoint);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "findSelectedBreakpoint"));
            }
            return pair;
        }
        Pair pair = Pair.create(null, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil", "findSelectedBreakpoint"));
        }
        return pair;
    }

    public static List<BreakpointPanelProvider> collectPanelProviders() {
        ArrayList<BreakpointPanelProvider> panelProviders = new ArrayList<BreakpointPanelProvider>();
        for (DebuggerSupport debuggerSupport : DebuggerSupport.getDebuggerSupports()) {
            panelProviders.add(debuggerSupport.getBreakpointPanelProvider());
        }
        Collections.sort(panelProviders, new Comparator<BreakpointPanelProvider>(){

            @Override
            public int compare(BreakpointPanelProvider o1, BreakpointPanelProvider o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        return panelProviders;
    }

    @Nullable
    public static DebuggerSupport getDebuggerSupport(Project project, BreakpointItem breakpointItem) {
        DebuggerSupport[] debuggerSupports = DebuggerSupport.getDebuggerSupports();
        ArrayList<BreakpointItem> items = new ArrayList<BreakpointItem>();
        for (DebuggerSupport support : debuggerSupports) {
            support.getBreakpointPanelProvider().provideBreakpointItems(project, items);
            if (items.contains(breakpointItem)) {
                return support;
            }
            items.clear();
        }
        return null;
    }

    public static XLineBreakpoint toggleLineBreakpoint(Project project, VirtualFile file, Editor editor, int lineStart, boolean temporary, boolean moveCarret) {
        FoldRegion region;
        int linesEnd = lineStart;
        if (editor != null && (region = FoldingUtil.findFoldRegionStartingAtLine(editor, lineStart)) != null && !region.isExpanded()) {
            linesEnd = region.getDocument().getLineNumber(region.getEndOffset());
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        XLineBreakpointType[] lineTypes = XDebuggerUtil.getInstance().getLineBreakpointTypes();
        XLineBreakpointType typeWinner = null;
        int lineWinner = -1;
        for (int line = lineStart; line <= linesEnd; ++line) {
            int maxPriority = 0;
            for (XLineBreakpointType type : lineTypes) {
                maxPriority = Math.max(maxPriority, type.getPriority());
                XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type, file, line);
                if (breakpoint != null && temporary && !breakpoint.isTemporary()) {
                    breakpoint.setTemporary(true);
                    continue;
                }
                if (!type.canPutAt(file, line, project) && breakpoint == null || typeWinner != null && type.getPriority() <= typeWinner.getPriority()) continue;
                typeWinner = type;
                lineWinner = line;
            }
            if (typeWinner != null && typeWinner.getPriority() == maxPriority) break;
        }
        if (typeWinner != null) {
            XLineBreakpoint res = XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project, typeWinner, file, lineWinner, temporary);
            if (editor != null && lineStart != lineWinner) {
                int offset = editor.getDocument().getLineStartOffset(lineWinner);
                ExpandRegionAction.expandRegionAtOffset(project, editor, offset);
                if (moveCarret) {
                    editor.getCaretModel().moveToOffset(offset);
                }
            }
            return res;
        }
        return null;
    }
}

