/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.XLightBreakpointPropertiesPanel;
import javax.swing.Icon;

class XBreakpointItem
extends BreakpointItem {
    private final XBreakpoint<?> myBreakpoint;
    private XLightBreakpointPropertiesPanel<XBreakpoint<?>> myPropertiesPanel;

    public XBreakpointItem(XBreakpoint<?> breakpoint) {
        this.myBreakpoint = breakpoint;
    }

    @Override
    public void setupRenderer(ColoredListCellRenderer renderer, Project project, boolean selected) {
        this.setupGenericRenderer((SimpleColoredComponent)renderer, true);
    }

    @Override
    public void setupRenderer(ColoredTreeCellRenderer renderer, Project project, boolean selected) {
        this.setupGenericRenderer((SimpleColoredComponent)renderer, false);
    }

    @Override
    public void setupGenericRenderer(SimpleColoredComponent renderer, boolean plainView) {
        if (plainView) {
            renderer.setIcon(this.getIcon());
        }
        SimpleTextAttributes attributes = this.myBreakpoint.isEnabled() ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        renderer.append(this.getDisplayText(), attributes);
    }

    @Override
    public String getDisplayText() {
        return XBreakpointUtil.getShortText(this.myBreakpoint);
    }

    @Override
    public Icon getIcon() {
        return ((XBreakpointBase)this.myBreakpoint).getIcon();
    }

    public String speedSearchText() {
        return ((XBreakpointBase)this.myBreakpoint).getType().getDisplayText(this.myBreakpoint);
    }

    public String footerText() {
        return ((XBreakpointBase)this.myBreakpoint).getType().getDisplayText(this.myBreakpoint);
    }

    @Override
    public void saveState() {
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.saveProperties();
        }
    }

    public void doUpdateDetailView(DetailView panel, boolean editorOnly) {
        XSourcePosition sourcePosition;
        Project project = ((XBreakpointBase)this.myBreakpoint).getProject();
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.dispose();
            this.myPropertiesPanel = null;
        }
        if (!editorOnly) {
            this.myPropertiesPanel = new XLightBreakpointPropertiesPanel(project, this.getManager(), this.myBreakpoint, true);
            panel.setPropertiesPanel(this.myPropertiesPanel.getMainPanel());
        }
        if ((sourcePosition = this.myBreakpoint.getSourcePosition()) != null) {
            XBreakpointItem.showInEditor(panel, sourcePosition.getFile(), sourcePosition.getLine());
        } else {
            panel.clearEditor();
        }
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.setDetailView(panel);
            this.myPropertiesPanel.loadProperties();
            this.myPropertiesPanel.getMainPanel().revalidate();
        }
    }

    public void navigate(boolean requestFocus) {
        Navigatable navigatable = this.myBreakpoint.getNavigatable();
        if (navigatable != null) {
            navigatable.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        Navigatable navigatable = this.myBreakpoint.getNavigatable();
        return navigatable != null && navigatable.canNavigate();
    }

    public boolean canNavigateToSource() {
        Navigatable navigatable = this.myBreakpoint.getNavigatable();
        return navigatable != null && navigatable.canNavigateToSource();
    }

    private XBreakpointManagerImpl getManager() {
        return ((XBreakpointBase)this.myBreakpoint).getBreakpointManager();
    }

    public boolean allowedToRemove() {
        return !this.getManager().isDefaultBreakpoint(this.myBreakpoint);
    }

    public void removed(Project project) {
        final XBreakpointManagerImpl breakpointManager = this.getManager();
        new WriteAction(){

            protected void run(Result result) {
                breakpointManager.removeBreakpoint(XBreakpointItem.this.myBreakpoint);
            }
        }.execute();
    }

    @Override
    public Object getBreakpoint() {
        return this.myBreakpoint;
    }

    @Override
    public boolean isEnabled() {
        return this.myBreakpoint.isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        this.myBreakpoint.setEnabled(state);
    }

    @Override
    public boolean isDefaultBreakpoint() {
        return this.getManager().isDefaultBreakpoint(this.myBreakpoint);
    }

    @Override
    public int compareTo(BreakpointItem breakpointItem) {
        if (breakpointItem.getBreakpoint() instanceof XBreakpointBase) {
            return ((XBreakpointBase)this.myBreakpoint).compareTo((XBreakpoint)breakpointItem.getBreakpoint());
        }
        return 0;
    }

    @Override
    public void dispose() {
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.dispose();
        }
    }
}

