/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.Navigatable;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerSupport;
import com.intellij.xdebugger.impl.actions.EditBreakpointAction;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.RemoveBreakpointGutterIconAction;
import com.intellij.xdebugger.impl.breakpoints.ToggleBreakpointGutterIconAction;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointBase<Self extends XBreakpoint<P>, P extends XBreakpointProperties, S extends BreakpointState>
extends UserDataHolderBase
implements XBreakpoint<P>,
Comparable<Self> {
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    @NonNls
    private static final String BR_NBSP = "<br>&nbsp;";
    private final XBreakpointType<Self, P> myType;
    @Nullable
    private final P myProperties;
    protected final S myState;
    private final XBreakpointManagerImpl myBreakpointManager;
    private Icon myIcon;
    private CustomizedBreakpointPresentation myCustomizedPresentation;

    public XBreakpointBase(XBreakpointType<Self, P> type, XBreakpointManagerImpl breakpointManager, @Nullable P properties, S state) {
        this.myState = state;
        this.myType = type;
        this.myProperties = properties;
        this.myBreakpointManager = breakpointManager;
    }

    protected XBreakpointBase(XBreakpointType<Self, P> type, XBreakpointManagerImpl breakpointManager, S breakpointState) {
        this.myState = breakpointState;
        this.myType = type;
        this.myBreakpointManager = breakpointManager;
        this.myProperties = type.createProperties();
        if (this.myProperties != null) {
            ComponentSerializationUtil.loadComponentState(this.myProperties, ((BreakpointState)this.myState).getPropertiesElement());
        }
    }

    public final Project getProject() {
        return this.myBreakpointManager.getProject();
    }

    protected XBreakpointManagerImpl getBreakpointManager() {
        return this.myBreakpointManager;
    }

    public final void fireBreakpointChanged() {
        this.clearIcon();
        this.myBreakpointManager.fireBreakpointChanged(this);
    }

    public XSourcePosition getSourcePosition() {
        return this.getType().getSourcePosition((XBreakpoint)this);
    }

    public Navigatable getNavigatable() {
        XSourcePosition position = this.getSourcePosition();
        if (position == null) {
            return null;
        }
        return position.createNavigatable(this.getProject());
    }

    public boolean isEnabled() {
        return ((BreakpointState)this.myState).isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            ((BreakpointState)this.myState).setEnabled(enabled);
            this.fireBreakpointChanged();
        }
    }

    @NotNull
    public SuspendPolicy getSuspendPolicy() {
        SuspendPolicy suspendPolicy = ((BreakpointState)this.myState).getSuspendPolicy();
        if (suspendPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "getSuspendPolicy"));
        }
        return suspendPolicy;
    }

    public void setSuspendPolicy(@NotNull SuspendPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "setSuspendPolicy"));
        }
        if (((BreakpointState)this.myState).getSuspendPolicy() != policy) {
            ((BreakpointState)this.myState).setSuspendPolicy(policy);
            this.fireBreakpointChanged();
        }
    }

    public boolean isLogMessage() {
        return ((BreakpointState)this.myState).isLogMessage();
    }

    public void setLogMessage(boolean logMessage) {
        if (logMessage != this.isLogMessage()) {
            ((BreakpointState)this.myState).setLogMessage(logMessage);
            this.fireBreakpointChanged();
        }
    }

    public String getLogExpression() {
        return ((BreakpointState)this.myState).getLogExpression();
    }

    public void setLogExpression(@Nullable String expression) {
        if (!Comparing.equal((String)this.getLogExpression(), (String)expression)) {
            ((BreakpointState)this.myState).setLogExpression(expression);
            this.fireBreakpointChanged();
        }
    }

    public String getCondition() {
        return ((BreakpointState)this.myState).getCondition();
    }

    public void setCondition(@Nullable String condition) {
        if (!Comparing.equal((String)condition, (String)this.getCondition())) {
            ((BreakpointState)this.myState).setCondition(condition);
            this.fireBreakpointChanged();
        }
    }

    public long getTimeStamp() {
        return ((BreakpointState)this.myState).getTimeStamp();
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public P getProperties() {
        return this.myProperties;
    }

    @NotNull
    public XBreakpointType<Self, P> getType() {
        XBreakpointType<Self, P> xBreakpointType = this.myType;
        if (xBreakpointType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "getType"));
        }
        return xBreakpointType;
    }

    public S getState() {
        Element propertiesElement = this.myProperties != null ? XmlSerializer.serialize((Object)this.myProperties.getState(), (SerializationFilter)SERIALIZATION_FILTERS) : null;
        ((BreakpointState)this.myState).setPropertiesElement(propertiesElement);
        return this.myState;
    }

    public XBreakpointDependencyState getDependencyState() {
        return ((BreakpointState)this.myState).getDependencyState();
    }

    public void setDependencyState(XBreakpointDependencyState state) {
        ((BreakpointState)this.myState).setDependencyState(state);
    }

    public void dispose() {
    }

    public String toString() {
        return "XBreakpointBase(type=" + this.myType + ")";
    }

    @Nullable
    protected GutterDraggableObject createBreakpointDraggableObject() {
        return null;
    }

    protected List<? extends AnAction> getAdditionalPopupMenuActions(XDebugSession session) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            XBreakpoint<?> masterBreakpoint;
            String logExpression;
            SuspendPolicy suspendPolicy;
            builder.append("<html><body>");
            builder.append(XBreakpointUtil.getDisplayText(this));
            String errorMessage = this.getErrorMessage();
            if (errorMessage != null) {
                builder.append(BR_NBSP);
                builder.append("<font color=\"red\">");
                builder.append(errorMessage);
                builder.append("</font>");
            }
            if ((suspendPolicy = this.getSuspendPolicy()) == SuspendPolicy.THREAD) {
                builder.append(BR_NBSP).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.suspend.policy.thread", (Object[])new Object[0]));
            } else if (suspendPolicy == SuspendPolicy.NONE) {
                builder.append(BR_NBSP).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.suspend.policy.none", (Object[])new Object[0]));
            }
            String condition = this.getCondition();
            if (condition != null) {
                builder.append(BR_NBSP);
                builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.condition", (Object[])new Object[0]));
                builder.append("&nbsp;");
                builder.append(condition);
            }
            if (this.isLogMessage()) {
                builder.append(BR_NBSP).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.log.message", (Object[])new Object[0]));
            }
            if ((logExpression = this.getLogExpression()) != null) {
                builder.append(BR_NBSP);
                builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.log.expression", (Object[])new Object[0]));
                builder.append("&nbsp;");
                builder.append(logExpression);
            }
            if ((masterBreakpoint = this.getBreakpointManager().getDependentBreakpointManager().getMasterBreakpoint(this)) != null) {
                builder.append(BR_NBSP);
                String str = XDebuggerBundle.message((String)"xbreakpoint.tooltip.depends.on", (Object[])new Object[0]);
                builder.append(str);
                builder.append("&nbsp;");
                builder.append(XBreakpointUtil.getDisplayText(masterBreakpoint));
            }
            builder.append("</body><html");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    protected void updateIcon() {
        Icon icon = this.calculateSpecialIcon();
        this.myIcon = icon != null ? icon : this.getType().getEnabledIcon();
    }

    protected void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    @Nullable
    protected final Icon calculateSpecialIcon() {
        Icon icon;
        if (!this.isEnabled()) {
            return this.getType().getDisabledIcon();
        }
        XDebugSessionImpl session = this.getBreakpointManager().getDebuggerManager().getCurrentSession();
        if (session == null) {
            if (this.getBreakpointManager().getDependentBreakpointManager().getMasterBreakpoint(this) != null) {
                return this.getType().getInactiveDependentIcon();
            }
        } else {
            Icon icon2;
            if (session.areBreakpointsMuted()) {
                return AllIcons.Debugger.Db_muted_breakpoint;
            }
            if (session.isInactiveSlaveBreakpoint(this)) {
                return this.getType().getInactiveDependentIcon();
            }
            CustomizedBreakpointPresentation presentation = session.getBreakpointPresentation(this);
            if (presentation != null && (icon2 = presentation.getIcon()) != null) {
                return icon2;
            }
        }
        if (this.myCustomizedPresentation != null && (icon = this.myCustomizedPresentation.getIcon()) != null) {
            return icon;
        }
        return null;
    }

    public Icon getIcon() {
        if (this.myIcon == null) {
            this.updateIcon();
        }
        return this.myIcon;
    }

    @Nullable
    public String getErrorMessage() {
        String message;
        CustomizedBreakpointPresentation presentation;
        XDebugSessionImpl currentSession = this.getBreakpointManager().getDebuggerManager().getCurrentSession();
        if (currentSession != null && (presentation = currentSession.getBreakpointPresentation(this)) != null && (message = presentation.getErrorMessage()) != null) {
            return message;
        }
        return this.myCustomizedPresentation != null ? this.myCustomizedPresentation.getErrorMessage() : null;
    }

    CustomizedBreakpointPresentation getCustomizedPresentation() {
        return this.myCustomizedPresentation;
    }

    public void setCustomizedPresentation(CustomizedBreakpointPresentation presentation) {
        this.myCustomizedPresentation = presentation;
    }

    @NotNull
    public GutterIconRenderer createGutterIconRenderer() {
        BreakpointGutterIconRenderer breakpointGutterIconRenderer = new BreakpointGutterIconRenderer();
        if (breakpointGutterIconRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "createGutterIconRenderer"));
        }
        return breakpointGutterIconRenderer;
    }

    public void clearIcon() {
        this.myIcon = null;
    }

    @Override
    public int compareTo(@NotNull Self self) {
        if (self == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase", "compareTo"));
        }
        return this.myType.getBreakpointComparator().compare(this, self);
    }

    protected class BreakpointGutterIconRenderer
    extends GutterIconRenderer {
        protected BreakpointGutterIconRenderer() {
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = XBreakpointBase.this.getIcon();
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase$BreakpointGutterIconRenderer", "getIcon"));
            }
            return icon;
        }

        @Nullable
        public AnAction getClickAction() {
            return new RemoveBreakpointGutterIconAction(XBreakpointBase.this);
        }

        @Nullable
        public AnAction getMiddleButtonClickAction() {
            return new ToggleBreakpointGutterIconAction(XBreakpointBase.this);
        }

        @Nullable
        public AnAction getRightButtonClickAction() {
            return new EditBreakpointAction.ContextAction(this, XBreakpointBase.this, DebuggerSupport.getDebuggerSupport(XDebuggerSupport.class));
        }

        public GutterIconRenderer.Alignment getAlignment() {
            return GutterIconRenderer.Alignment.RIGHT;
        }

        @Nullable
        public ActionGroup getPopupMenuActions() {
            return null;
        }

        @Nullable
        public String getTooltipText() {
            return XBreakpointBase.this.getDescription();
        }

        public GutterDraggableObject getDraggableObject() {
            return XBreakpointBase.this.createBreakpointDraggableObject();
        }

        private XBreakpointBase<?, ?, ?> getBreakpoint() {
            return XBreakpointBase.this;
        }

        public boolean equals(Object obj) {
            return obj instanceof BreakpointGutterIconRenderer && this.getBreakpoint() == ((BreakpointGutterIconRenderer)((Object)obj)).getBreakpoint() && Comparing.equal((Object)this.getIcon(), (Object)((BreakpointGutterIconRenderer)((Object)obj)).getIcon());
        }

        public int hashCode() {
            return this.getBreakpoint().hashCode();
        }
    }
}

