/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class QuickEvaluateAction
extends XDebuggerActionBase {
    public QuickEvaluateAction() {
        super(true);
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        if (debuggerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/actions/QuickEvaluateAction", "getHandler"));
        }
        QuickEvaluateHandlerWrapper quickEvaluateHandlerWrapper = new QuickEvaluateHandlerWrapper(debuggerSupport.getQuickEvaluateHandler());
        if (quickEvaluateHandlerWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/QuickEvaluateAction", "getHandler"));
        }
        return quickEvaluateHandlerWrapper;
    }

    private static class QuickEvaluateHandlerWrapper
    extends DebuggerActionHandler {
        private final QuickEvaluateHandler myHandler;

        public QuickEvaluateHandlerWrapper(QuickEvaluateHandler handler) {
            this.myHandler = handler;
        }

        @Override
        public void perform(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/actions/QuickEvaluateAction$QuickEvaluateHandlerWrapper", "perform"));
            }
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
                ValueLookupManager.getInstance(project).showHint(this.myHandler, editor, editor.logicalPositionToXY(logicalPosition), ValueHintType.MOUSE_CLICK_HINT);
            }
        }

        @Override
        public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
            MouseEvent convertedEvent;
            EditorMouseEventArea area;
            MouseEvent mouseEvent;
            Component component;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/actions/QuickEvaluateAction$QuickEvaluateHandlerWrapper", "isEnabled"));
            }
            if (!this.myHandler.isEnabled(project)) {
                return false;
            }
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                return false;
            }
            InputEvent inputEvent = event.getInputEvent();
            return !(inputEvent instanceof MouseEvent) || !inputEvent.isAltDown() || !SwingUtilities.isDescendingFrom(component = SwingUtilities.getDeepestComponentAt((mouseEvent = (MouseEvent)inputEvent).getComponent(), mouseEvent.getX(), mouseEvent.getY()), editor.getComponent()) || (area = editor.getMouseEventArea(convertedEvent = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, component))) == EditorMouseEventArea.EDITING_AREA;
        }
    }
}

