/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroupingRule;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingsManager;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerUtilImpl
extends XDebuggerUtil {
    private XLineBreakpointType<?>[] myLineBreakpointTypes;
    private Map<Class<? extends XBreakpointType>, XBreakpointType<?, ?>> myBreakpointTypeByClass;

    public XLineBreakpointType<?>[] getLineBreakpointTypes() {
        if (this.myLineBreakpointTypes == null) {
            XBreakpointType<?, ?>[] types = XBreakpointUtil.getBreakpointTypes();
            ArrayList<XLineBreakpointType> lineBreakpointTypes = new ArrayList<XLineBreakpointType>();
            for (XBreakpointType<?, ?> type : types) {
                if (!(type instanceof XLineBreakpointType)) continue;
                lineBreakpointTypes.add((XLineBreakpointType)type);
            }
            this.myLineBreakpointTypes = lineBreakpointTypes.toArray(new XLineBreakpointType[lineBreakpointTypes.size()]);
        }
        return this.myLineBreakpointTypes;
    }

    public void toggleLineBreakpoint(@NotNull Project project, @NotNull VirtualFile file, int line, boolean temporary) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        XLineBreakpointType<?> typeWinner = null;
        for (XLineBreakpointType<?> type : this.getLineBreakpointTypes()) {
            if (!type.canPutAt(file, line, project) || typeWinner != null && type.getPriority() <= typeWinner.getPriority()) continue;
            typeWinner = type;
        }
        if (typeWinner != null) {
            this.toggleLineBreakpoint(project, typeWinner, file, line, temporary);
        }
    }

    public boolean canPutBreakpointAt(@NotNull Project project, @NotNull VirtualFile file, int line) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "canPutBreakpointAt"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "canPutBreakpointAt"));
        }
        for (XLineBreakpointType<?> type : this.getLineBreakpointTypes()) {
            if (!type.canPutAt(file, line, project)) continue;
            return true;
        }
        return false;
    }

    public <P extends XBreakpointProperties> void toggleLineBreakpoint(@NotNull Project project, @NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file, int line, boolean temporary) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project, type, file, line, temporary);
    }

    public static <P extends XBreakpointProperties> XLineBreakpoint toggleAndReturnLineBreakpoint(final @NotNull Project project, final @NotNull XLineBreakpointType<P> type, final @NotNull VirtualFile file, final int line, final boolean temporary) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        return (XLineBreakpoint)new WriteAction<XLineBreakpoint>(){

            protected void run(@NotNull Result<XLineBreakpoint> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$1", "run"));
                }
                XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
                XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type, file, line);
                if (breakpoint != null) {
                    breakpointManager.removeBreakpoint((XBreakpoint)breakpoint);
                } else {
                    XBreakpointProperties properties = type.createBreakpointProperties(file, line);
                    result.setResult((Object)breakpointManager.addLineBreakpoint(type, file.getUrl(), line, properties, temporary));
                }
            }
        }.execute().getResultObject();
    }

    public void removeBreakpoint(final Project project, final XBreakpoint<?> breakpoint) {
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$2", "run"));
                }
                XDebuggerManager.getInstance((Project)project).getBreakpointManager().removeBreakpoint(breakpoint);
            }
        }.execute();
    }

    public <B extends XBreakpoint<?>> XBreakpointType<B, ?> findBreakpointType(@NotNull Class<? extends XBreakpointType<B, ?>> typeClass) {
        if (typeClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "findBreakpointType"));
        }
        if (this.myBreakpointTypeByClass == null) {
            this.myBreakpointTypeByClass = new THashMap();
            for (XBreakpointType<?, ?> breakpointType : XBreakpointUtil.getBreakpointTypes()) {
                this.myBreakpointTypeByClass.put(breakpointType.getClass(), breakpointType);
            }
        }
        XBreakpointType<?, ?> type = this.myBreakpointTypeByClass.get(typeClass);
        return type;
    }

    public <T extends XDebuggerSettings<?>> T getDebuggerSettings(Class<T> aClass) {
        return XDebuggerSettingsManager.getInstance().getSettings(aClass);
    }

    public XValueContainer getValueContainer(DataContext dataContext) {
        return XDebuggerTreeActionBase.getSelectedValue(dataContext);
    }

    @Nullable
    public XSourcePosition createPosition(VirtualFile file, int line) {
        return XSourcePositionImpl.create(file, line);
    }

    @Nullable
    public XSourcePosition createPositionByOffset(VirtualFile file, int offset) {
        return XSourcePositionImpl.createByOffset(file, offset);
    }

    public <B extends XLineBreakpoint<?>> XBreakpointGroupingRule<B, ?> getGroupingByFileRule() {
        return new XBreakpointFileGroupingRule();
    }

    @Nullable
    public static XSourcePosition getCaretPosition(@NotNull Project project, DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getCaretPosition"));
        }
        Editor editor = XDebuggerUtilImpl.getEditor(project, context);
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        int line = editor.getCaretModel().getLogicalPosition().line;
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        return XSourcePositionImpl.create(file, line);
    }

    @Nullable
    private static Editor getEditor(@NotNull Project project, DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getEditor"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            return FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        }
        return editor;
    }

    public <B extends XBreakpoint<?>> Comparator<B> getDefaultBreakpointComparator(final XBreakpointType<B, ?> type) {
        return new Comparator<B>(){

            @Override
            public int compare(B o1, B o2) {
                return type.getDisplayText(o1).compareTo(type.getDisplayText(o2));
            }
        };
    }

    public <P extends XBreakpointProperties> Comparator<XLineBreakpoint<P>> getDefaultLineBreakpointComparator() {
        return new Comparator<XLineBreakpoint<P>>(){

            @Override
            public int compare(XLineBreakpoint<P> o1, XLineBreakpoint<P> o2) {
                int fileCompare = o1.getFileUrl().compareTo(o2.getFileUrl());
                if (fileCompare != 0) {
                    return fileCompare;
                }
                return o1.getLine() - o2.getLine();
            }
        };
    }

    @Nullable
    public static XDebuggerEvaluator getEvaluator(XSuspendContext suspendContext) {
        XStackFrame stackFrame;
        XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
        if (executionStack != null && (stackFrame = executionStack.getTopFrame()) != null) {
            return stackFrame.getEvaluator();
        }
        return null;
    }

    public void iterateLine(@NotNull Project project, @NotNull Document document, int line, @NotNull Processor<PsiElement> processor) {
        int lineEnd;
        int lineStart;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "iterateLine"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "iterateLine"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "iterateLine"));
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return;
        }
        try {
            lineStart = document.getLineStartOffset(line);
            lineEnd = document.getLineEndOffset(line);
        }
        catch (IndexOutOfBoundsException ignored) {
            return;
        }
        int offset = lineStart;
        while (offset < lineEnd) {
            PsiElement element = file.findElementAt(offset);
            if (element != null) {
                if (!processor.process((Object)element)) {
                    return;
                }
                offset = element.getTextRange().getEndOffset();
                continue;
            }
            ++offset;
        }
    }

    public <B extends XLineBreakpoint<?>> List<XBreakpointGroupingRule<B, ?>> getGroupingByFileRuleAsList() {
        return Collections.singletonList(this.getGroupingByFileRule());
    }

    @Nullable
    public PsiElement findContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project, boolean checkXml) {
        PsiLanguageInjectionHost parent;
        PsiElement element;
        PsiFile file;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "findContextElement"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "findContextElement"));
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        PsiFile psiFile = file = document == null ? null : PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (file == null) {
            return null;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > document.getTextLength()) {
            offset = document.getTextLength();
        }
        int startOffset = offset;
        int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
        PsiElement result = null;
        do {
            if ((element = file.findElementAt(offset)) instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            result = element;
            break;
        } while ((offset = element.getTextRange().getEndOffset() + 1) < lineEndOffset);
        if (result == null) {
            result = file.findElementAt(startOffset);
        }
        if (checkXml && result != null && StdFileTypes.XML.getLanguage().equals(result.getLanguage()) && (parent = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)result, PsiLanguageInjectionHost.class)) != null) {
            result = InjectedLanguageUtil.findElementInInjected(parent, offset);
        }
        return result;
    }

    public void disableValueLookup(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "disableValueLookup"));
        }
        ValueLookupManager.DISABLE_VALUE_LOOKUP.set((UserDataHolder)editor, (Object)Boolean.TRUE);
    }

    @Nullable
    public static Editor createEditor(@NotNull OpenFileDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "createEditor"));
        }
        return descriptor.canNavigate() ? FileEditorManager.getInstance((Project)descriptor.getProject()).openTextEditor(descriptor, false) : null;
    }
}

