/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.AppTopics;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointAdapter;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XDebuggerManager", storages={@Storage(file="$WORKSPACE_FILE$")})
public class XDebuggerManagerImpl
extends XDebuggerManager
implements ProjectComponent,
PersistentStateComponent<XDebuggerState> {
    @NonNls
    public static final String COMPONENT_NAME = "XDebuggerManager";
    private final Project myProject;
    private final XBreakpointManagerImpl myBreakpointManager;
    private final Map<RunContentDescriptor, XDebugSessionData> mySessionData;
    private final Map<RunContentDescriptor, XDebugSessionTab> mySessionTabs;
    private final Map<ProcessHandler, XDebugSessionImpl> mySessions;
    private final ExecutionPointHighlighter myExecutionPointHighlighter;
    private XDebugSessionImpl myActiveSession;

    public XDebuggerManagerImpl(Project project, StartupManager startupManager, MessageBus messageBus) {
        this.myProject = project;
        this.myBreakpointManager = new XBreakpointManagerImpl(project, this, startupManager);
        this.mySessionData = new THashMap();
        this.mySessionTabs = new THashMap();
        this.mySessions = new LinkedHashMap<ProcessHandler, XDebugSessionImpl>();
        this.myExecutionPointHighlighter = new ExecutionPointHighlighter(project);
        MessageBusConnection messageBusConnection = messageBus.connect();
        messageBusConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentLoaded(@NotNull VirtualFile file, @NotNull Document document) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerManagerImpl$1", "fileContentLoaded"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerManagerImpl$1", "fileContentLoaded"));
                }
                if (file.equals(XDebuggerManagerImpl.this.myExecutionPointHighlighter.getCurrentFile())) {
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.update();
                }
            }

            public void fileContentReloaded(@NotNull VirtualFile file, @NotNull Document document) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerManagerImpl$1", "fileContentReloaded"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerManagerImpl$1", "fileContentReloaded"));
                }
                XDebuggerManagerImpl.this.myExecutionPointHighlighter.update();
            }
        });
        this.myBreakpointManager.addBreakpointListener((XBreakpointListener<XBreakpoint<?>>)new XBreakpointAdapter<XBreakpoint<?>>(){

            public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session;
                if (breakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerManagerImpl$2", "breakpointChanged"));
                }
                if (!(breakpoint instanceof XLineBreakpoint) && (session = XDebuggerManagerImpl.this.getCurrentSession()) != null && breakpoint.equals(session.getActiveNonLineBreakpoint())) {
                    XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
                    breakpointBase.clearIcon();
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(breakpointBase.createGutterIconRenderer());
                }
            }
        });
        messageBusConnection.subscribe(RunContentManagerImpl.RUN_CONTENT_TOPIC, (Object)new RunContentWithExecutorListener(){

            @Override
            public void contentSelected(RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerManagerImpl$3", "contentSelected"));
                }
                if (executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
                    XDebugSessionImpl session = (XDebugSessionImpl)XDebuggerManagerImpl.this.mySessions.get(descriptor.getProcessHandler());
                    if (session != null) {
                        session.activateSession();
                    } else {
                        XDebuggerManagerImpl.this.setActiveSession(null, null, false, null);
                    }
                }
            }

            @Override
            public void contentRemoved(RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerManagerImpl$3", "contentRemoved"));
                }
                if (executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
                    XDebuggerManagerImpl.this.mySessions.remove(descriptor.getProcessHandler());
                    XDebuggerManagerImpl.this.mySessionData.remove(descriptor);
                    XDebugSessionTab tab = (XDebugSessionTab)XDebuggerManagerImpl.this.mySessionTabs.remove(descriptor);
                    if (tab != null) {
                        Disposer.dispose((Disposable)tab);
                    }
                }
            }
        });
    }

    @NotNull
    public XBreakpointManagerImpl getBreakpointManager() {
        XBreakpointManagerImpl xBreakpointManagerImpl = this.myBreakpointManager;
        if (xBreakpointManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "getBreakpointManager"));
        }
        return xBreakpointManagerImpl;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "getComponentName"));
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public XDebugSession startSession(@NotNull ProgramRunner runner, @NotNull ExecutionEnvironment env, @Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter processStarter) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSession"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSession"));
        }
        if (processStarter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSession"));
        }
        XDebugSessionImpl xDebugSessionImpl = this.startSession(contentToReuse, processStarter, new XDebugSessionImpl(env, runner, this));
        if (xDebugSessionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSession"));
        }
        return xDebugSessionImpl;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        if (sessionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSessionAndShowTab"));
        }
        if (starter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSessionAndShowTab"));
        }
        XDebugSession xDebugSession = this.startSessionAndShowTab(sessionName, contentToReuse, false, starter);
        if (xDebugSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSessionAndShowTab"));
        }
        return xDebugSession;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        if (sessionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSessionAndShowTab"));
        }
        if (starter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSessionAndShowTab"));
        }
        XDebugSession xDebugSession = this.startSessionAndShowTab(sessionName, null, contentToReuse, showToolWindowOnSuspendOnly, starter);
        if (xDebugSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSessionAndShowTab"));
        }
        return xDebugSession;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, Icon icon, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        if (sessionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSessionAndShowTab"));
        }
        if (starter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSessionAndShowTab"));
        }
        XDebugSessionImpl session = this.startSession(contentToReuse, starter, new XDebugSessionImpl(null, null, this, sessionName, icon, showToolWindowOnSuspendOnly));
        if (!showToolWindowOnSuspendOnly) {
            session.showSessionTab();
        }
        ProcessHandler handler = session.getDebugProcess().getProcessHandler();
        handler.startNotify();
        XDebugSessionImpl xDebugSessionImpl = session;
        if (xDebugSessionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "startSessionAndShowTab"));
        }
        return xDebugSessionImpl;
    }

    private XDebugSessionImpl startSession(RunContentDescriptor contentToReuse, XDebugProcessStarter processStarter, XDebugSessionImpl session) throws ExecutionException {
        XDebugSessionData oldSessionData;
        XDebugProcess process = processStarter.start((XDebugSession)session);
        XDebugSessionData xDebugSessionData = oldSessionData = contentToReuse != null ? this.mySessionData.get(contentToReuse) : null;
        if (oldSessionData == null) {
            oldSessionData = new XDebugSessionData();
        }
        session.init(process, oldSessionData);
        this.mySessions.put(session.getDebugProcess().getProcessHandler(), session);
        return session;
    }

    public void removeSession(final @NotNull XDebugSessionImpl session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "removeSession"));
        }
        XDebugSessionTab sessionTab = session.getSessionTab();
        this.mySessions.remove(session.getDebugProcess().getProcessHandler());
        if (sessionTab != null) {
            final RunContentDescriptor descriptor = sessionTab.getRunContentDescriptor();
            this.mySessionData.put(descriptor, session.getSessionData());
            this.mySessionTabs.put(descriptor, sessionTab);
            Disposer.register((Disposable)sessionTab, (Disposable)new Disposable(){

                public void dispose() {
                    XDebuggerManagerImpl.this.mySessionData.remove(descriptor);
                    XDebuggerManagerImpl.this.mySessionTabs.remove(descriptor);
                    XDebuggerManagerImpl.this.mySessions.remove(session.getDebugProcess().getProcessHandler());
                }
            });
        }
        if (this.myActiveSession == session) {
            this.myActiveSession = null;
            this.onActiveSessionChanged();
        }
    }

    public void setActiveSession(@Nullable XDebugSessionImpl session, @Nullable XSourcePosition position, boolean useSelection, @Nullable GutterIconRenderer gutterIconRenderer) {
        boolean sessionChanged = this.myActiveSession != session;
        this.myActiveSession = session;
        this.updateExecutionPoint(position, useSelection, gutterIconRenderer);
        if (sessionChanged) {
            this.onActiveSessionChanged();
        }
    }

    public void updateExecutionPoint(XSourcePosition position, boolean useSelection, @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position != null) {
            this.myExecutionPointHighlighter.show(position, useSelection, gutterIconRenderer);
        } else {
            this.myExecutionPointHighlighter.hide();
        }
    }

    private void onActiveSessionChanged() {
        this.myBreakpointManager.getLineBreakpointManager().queueAllBreakpointsUpdate();
    }

    @NotNull
    public XDebugSession[] getDebugSessions() {
        Collection<XDebugSessionImpl> sessions = this.mySessions.values();
        XDebugSession[] xDebugSessionArray = sessions.toArray(new XDebugSessionImpl[sessions.size()]);
        if (xDebugSessionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "getDebugSessions"));
        }
        return xDebugSessionArray;
    }

    @Nullable
    public XDebugSession getDebugSession(@NotNull ExecutionConsole executionConsole) {
        if (executionConsole == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "getDebugSession"));
        }
        for (XDebugSessionImpl debuggerSession : this.mySessions.values()) {
            RunContentDescriptor contentDescriptor;
            XDebugSessionTab sessionTab = debuggerSession.getSessionTab();
            if (sessionTab == null || (contentDescriptor = sessionTab.getRunContentDescriptor()) == null || executionConsole != contentDescriptor.getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }

    @NotNull
    public <T extends XDebugProcess> List<? extends T> getDebugProcesses(Class<T> processClass) {
        SmartList list = null;
        for (XDebugSessionImpl session : this.mySessions.values()) {
            XDebugProcess process = session.getDebugProcess();
            if (!processClass.isInstance(process)) continue;
            if (list == null) {
                list = new SmartList();
            }
            list.add(processClass.cast(process));
        }
        List<Object> list2 = list == null ? Collections.emptyList() : list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerManagerImpl", "getDebugProcesses"));
        }
        return list2;
    }

    @Nullable
    public XDebugSessionImpl getCurrentSession() {
        return this.myActiveSession;
    }

    public XDebuggerState getState() {
        return new XDebuggerState(this.myBreakpointManager.getState());
    }

    public void loadState(XDebuggerState state) {
        this.myBreakpointManager.loadState(state.myBreakpointManagerState);
    }

    public void showExecutionPosition() {
        this.myExecutionPointHighlighter.navigateTo();
    }

    public static class XDebuggerState {
        private XBreakpointManagerImpl.BreakpointManagerState myBreakpointManagerState;

        public XDebuggerState() {
        }

        public XDebuggerState(XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState) {
            this.myBreakpointManagerState = breakpointManagerState;
        }

        @Property(surroundWithTag=false)
        public XBreakpointManagerImpl.BreakpointManagerState getBreakpointManagerState() {
            return this.myBreakpointManagerState;
        }

        public void setBreakpointManagerState(XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState) {
            this.myBreakpointManagerState = breakpointManagerState;
        }
    }
}

