/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XDebuggerHistoryManager {
    public static final int MAX_RECENT_EXPRESSIONS = 10;
    private final Map<String, LinkedList<String>> myRecentExpressions = new HashMap<String, LinkedList<String>>();

    public static XDebuggerHistoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerHistoryManager", "getInstance"));
        }
        return (XDebuggerHistoryManager)ServiceManager.getService((Project)project, XDebuggerHistoryManager.class);
    }

    public void addRecentExpression(@NotNull @NonNls String id, @NotNull String expression) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerHistoryManager", "addRecentExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebuggerHistoryManager", "addRecentExpression"));
        }
        if (StringUtil.isEmptyOrSpaces((String)expression)) {
            return;
        }
        LinkedList<String> list = this.myRecentExpressions.get(id);
        if (list == null) {
            list = new LinkedList();
            this.myRecentExpressions.put(id, list);
        }
        if (list.size() == 10) {
            list.removeLast();
        }
        String trimmedExpression = expression.trim();
        list.remove(trimmedExpression);
        list.addFirst(trimmedExpression);
    }

    public List<String> getRecentExpressions(@NonNls String id) {
        LinkedList<String> list = this.myRecentExpressions.get(id);
        return list != null ? list : Collections.emptyList();
    }
}

