/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagesNotificationPanel {
    private final JEditorPane myEditorPane = new MyNotificationPane();
    private final Project myProject;
    private final Map<String, Runnable> myLinkHandlers = new HashMap<String, Runnable>();
    private String myErrorTitle;
    private String myErrorDescription;

    public PackagesNotificationPanel(Project project) {
        this.myProject = project;
        this.myEditorPane.setBackground(UIManager.getColor("ArrowButton.background"));
        this.myEditorPane.setContentType("text/html");
        this.myEditorPane.setEditable(false);
        this.myEditorPane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                Runnable handler = (Runnable)PackagesNotificationPanel.this.myLinkHandlers.get(e.getDescription());
                if (handler != null) {
                    handler.run();
                } else if (PackagesNotificationPanel.this.myErrorTitle != null && PackagesNotificationPanel.this.myErrorDescription != null) {
                    PackagesNotificationPanel.showError(PackagesNotificationPanel.this.myProject, PackagesNotificationPanel.this.myErrorTitle, PackagesNotificationPanel.this.myErrorDescription);
                }
            }
        });
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String description) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/webcore/packaging/PackagesNotificationPanel", "showError"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/webcore/packaging/PackagesNotificationPanel", "showError"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/webcore/packaging/PackagesNotificationPanel", "showError"));
        }
        PackagesNotificationPanel.doShowError(title, description, new DialogBuilder(project));
    }

    public static void showError(@NotNull Component owner, @NotNull String title, @NotNull String description) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/webcore/packaging/PackagesNotificationPanel", "showError"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/webcore/packaging/PackagesNotificationPanel", "showError"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/webcore/packaging/PackagesNotificationPanel", "showError"));
        }
        PackagesNotificationPanel.doShowError(title, description, new DialogBuilder(owner));
    }

    private static void doShowError(String title, String description, DialogBuilder builder) {
        builder.setTitle(title);
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setText(description);
        textArea.setWrapStyleWord(false);
        textArea.setLineWrap(true);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)textArea);
        scrollPane.setHorizontalScrollBarPolicy(31);
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        panel.setPreferredSize(new Dimension(600, 400));
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)new JBLabel("Details:", Messages.getErrorIcon(), 2), "North");
        builder.setCenterPanel((JComponent)panel);
        builder.setButtonsAlignment(0);
        builder.addOkAction();
        builder.show();
    }

    public void showResult(String packageName, @Nullable String errorDescription) {
        if (StringUtil.isEmpty((String)errorDescription)) {
            this.showSuccess("Package successfully installed.");
        } else {
            String title = "Install packages failed";
            String firstLine = title + ": Error occurred when installing package " + packageName + ". ";
            this.showError(firstLine + "<a href=\"xxx\">Details...</a>", title, firstLine + errorDescription);
        }
    }

    public void addLinkHandler(String key, Runnable handler) {
        this.myLinkHandlers.put(key, handler);
    }

    public void removeAllLinkHandlers() {
        this.myLinkHandlers.clear();
    }

    public JComponent getComponent() {
        return this.myEditorPane;
    }

    public void showSuccess(String text) {
        this.showContent(text, MessageType.INFO.getPopupBackground());
    }

    private void showContent(String text, Color background) {
        this.myEditorPane.removeAll();
        String htmlText = text.startsWith("<html>") ? text : UIUtil.toHtml((String)text);
        this.myEditorPane.setText(htmlText);
        this.myEditorPane.setBackground(background);
        this.myEditorPane.setVisible(true);
        this.myErrorTitle = null;
        this.myErrorDescription = null;
    }

    public void showError(String text, String detailsTitle, String detailsDescription) {
        this.showContent(text, MessageType.ERROR.getPopupBackground());
        this.myErrorTitle = detailsTitle;
        this.myErrorDescription = detailsDescription;
    }

    public void showWarning(String text) {
        this.showContent(text, MessageType.WARNING.getPopupBackground());
    }

    public void hide() {
        this.myEditorPane.setVisible(false);
    }

    public boolean hasLinkHandler(String key) {
        return this.myLinkHandlers.containsKey(key);
    }

    public void removeLinkHandler(String key) {
        this.myLinkHandlers.remove(key);
    }

    private static class MyNotificationPane
    extends JEditorPane {
        private MyNotificationPane() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 0;
            return dimension;
        }
    }
}

