/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.tables;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.LoadMoreStage;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.graph.render.GraphCommitCell;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.tables.AbstractVcsLogTableModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableModel
extends AbstractVcsLogTableModel<GraphCommitCell> {
    private static final Logger LOG = Logger.getInstance(GraphTableModel.class);
    @NotNull
    private final DataPack myDataPack;
    @NotNull
    private final VcsLogDataHolder myDataHolder;

    public GraphTableModel(@NotNull DataPack dataPack, @NotNull VcsLogDataHolder dataHolder, @NotNull VcsLogUiImpl UI2, @NotNull LoadMoreStage loadMoreStage) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/tables/GraphTableModel", "<init>"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/tables/GraphTableModel", "<init>"));
        }
        if (UI2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/tables/GraphTableModel", "<init>"));
        }
        if (loadMoreStage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/ui/tables/GraphTableModel", "<init>"));
        }
        super(dataHolder, UI2, dataPack, loadMoreStage);
        this.myDataPack = dataPack;
        this.myDataHolder = dataHolder;
    }

    @Override
    public int getRowCount() {
        return this.myDataPack.getGraphFacade().getVisibleCommitCount();
    }

    @Override
    public void requestToLoadMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/tables/GraphTableModel", "requestToLoadMore"));
        }
        if (!this.myDataHolder.isFullLogShowing()) {
            this.myDataHolder.showFullLog(onLoaded);
        } else if (!this.myUi.getFilters().isEmpty()) {
            super.requestToLoadMore(onLoaded);
        }
    }

    @Override
    public boolean canRequestMore() {
        return !this.myDataHolder.isFullLogShowing() || super.canRequestMore();
    }

    @Override
    @NotNull
    public VirtualFile getRoot(int rowIndex) {
        int head = this.myDataPack.getGraphFacade().getInfoProvider().getRowInfo(rowIndex).getOneOfHeads();
        Collection<VcsRef> refs = this.myDataPack.getRefsModel().refsToCommit(head);
        if (refs.isEmpty()) {
            LOG.error("No references pointing to head " + head + " identified for commit at row " + rowIndex);
            VirtualFile virtualFile = this.myDataPack.getLogProviders().keySet().iterator().next();
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getRoot"));
            }
            return virtualFile;
        }
        VirtualFile virtualFile = refs.iterator().next().getRoot();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getRoot"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    protected GraphCommitCell getCommitColumnCell(int rowIndex, @Nullable VcsShortCommitDetails details) {
        String message = "";
        List refs = Collections.emptyList();
        if (details != null) {
            message = details.getSubject();
            refs = (List)this.myDataPack.getRefsModel().refsToCommit(details.getHash());
        }
        GraphCommitCell graphCommitCell = new GraphCommitCell(message, refs);
        if (graphCommitCell == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getCommitColumnCell"));
        }
        return graphCommitCell;
    }

    @Override
    @NotNull
    protected Class<GraphCommitCell> getCommitColumnClass() {
        if (GraphCommitCell.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getCommitColumnClass"));
        }
        return GraphCommitCell.class;
    }

    @Override
    @Nullable
    public Hash getHashAtRow(int row) {
        return this.myDataHolder.getHash(this.myDataPack.getGraphFacade().getCommitAtRow(row));
    }

    @Override
    public int getRowOfCommit(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getRowOfCommit"));
        }
        final int commitIndex = this.myDataHolder.getCommitIndex(hash);
        return ContainerUtil.indexOf(VcsLogUtil.getVisibleCommits(this.myDataPack.getGraphFacade()), (Condition)new Condition<Integer>(){

            public boolean value(Integer integer) {
                return integer == commitIndex;
            }
        });
    }

    @Override
    public int getRowOfCommitByPartOfHash(@NotNull String partialHash) {
        if (partialHash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getRowOfCommitByPartOfHash"));
        }
        Hash hash = this.myDataHolder.findHashByString(partialHash);
        return hash != null ? this.getRowOfCommit(hash) : -1;
    }
}

