/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.tables;

import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.LoadMoreStage;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsLogTableModel<CommitColumnClass>
extends AbstractTableModel {
    public static final int ROOT_COLUMN = 0;
    public static final int COMMIT_COLUMN = 1;
    public static final int AUTHOR_COLUMN = 2;
    public static final int DATE_COLUMN = 3;
    private static final int COLUMN_COUNT = 4;
    private static final String[] COLUMN_NAMES = new String[]{"", "Subject", "Author", "Date"};
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    protected final VcsLogUiImpl myUi;
    @NotNull
    protected final DataPack myDataPack;
    @NotNull
    private final LoadMoreStage myLoadMoreStage;
    @NotNull
    private final AtomicBoolean myLoadMoreWasRequested;

    protected AbstractVcsLogTableModel(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiImpl ui, @NotNull DataPack dataPack, @NotNull LoadMoreStage loadMoreStage) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "<init>"));
        }
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "<init>"));
        }
        if (loadMoreStage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "<init>"));
        }
        this.myLoadMoreWasRequested = new AtomicBoolean();
        this.myLogDataHolder = logDataHolder;
        this.myUi = ui;
        this.myDataPack = dataPack;
        this.myLoadMoreStage = loadMoreStage;
    }

    @Override
    public final int getColumnCount() {
        return 4;
    }

    @Nullable
    protected VcsShortCommitDetails getShortDetails(int rowIndex) {
        return this.myLogDataHolder.getMiniDetailsGetter().getCommitData(rowIndex, this);
    }

    @Nullable
    public VcsFullCommitDetails getFullCommitDetails(int rowIndex) {
        return (VcsFullCommitDetails)this.myLogDataHolder.getCommitDetailsGetter().getCommitData(rowIndex, this);
    }

    public void requestToLoadMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "requestToLoadMore"));
        }
        if (this.myLoadMoreWasRequested.compareAndSet(false, true) && this.myLoadMoreStage != LoadMoreStage.ALL_REQUESTED) {
            this.myUi.getTable().setPaintBusy(true);
            this.myUi.getFilterer().requestVcs(this.myDataPack, this.myUi.getFilters(), this.myLoadMoreStage, onLoaded);
        }
    }

    @Override
    @NotNull
    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount() - 1) {
            this.requestToLoadMore(EmptyRunnable.INSTANCE);
        }
        VcsShortCommitDetails data = this.getShortDetails(rowIndex);
        switch (columnIndex) {
            case 0: {
                VirtualFile virtualFile = this.getRoot(rowIndex);
                if (virtualFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "getValueAt"));
                }
                return virtualFile;
            }
            case 1: {
                CommitColumnClass CommitColumnClass = this.getCommitColumnCell(rowIndex, data);
                if (CommitColumnClass == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "getValueAt"));
                }
                return CommitColumnClass;
            }
            case 2: {
                if (data == null) {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "getValueAt"));
                    }
                    return "";
                }
                String string = data.getAuthor().getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "getValueAt"));
                }
                return string;
            }
            case 3: {
                if (data == null || data.getTime() < 0L) {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "getValueAt"));
                    }
                    return "";
                }
                String string = DateFormatUtil.formatDateTime((long)data.getTime());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "getValueAt"));
                }
                return string;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + columnIndex + " > " + 3);
    }

    public boolean canRequestMore() {
        return !this.myUi.getFilters().isEmpty() && this.myLoadMoreStage != LoadMoreStage.ALL_REQUESTED;
    }

    @Nullable
    public List<Change> getSelectedChanges(@NotNull List<Integer> selectedRows) {
        if (selectedRows == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/tables/AbstractVcsLogTableModel", "getSelectedChanges"));
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (int row : selectedRows) {
            VcsFullCommitDetails commitData = this.getFullCommitDetails(row);
            if (commitData == null || commitData instanceof LoadingDetails) {
                return null;
            }
            changes.addAll(commitData.getChanges());
        }
        return changes;
    }

    @NotNull
    public abstract VirtualFile getRoot(int var1);

    @NotNull
    protected abstract CommitColumnClass getCommitColumnCell(int var1, @Nullable VcsShortCommitDetails var2);

    @NotNull
    protected abstract Class<CommitColumnClass> getCommitColumnClass();

    @Nullable
    public abstract Hash getHashAtRow(int var1);

    public abstract int getRowOfCommit(@NotNull Hash var1);

    public abstract int getRowOfCommitByPartOfHash(@NotNull String var1);

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return VirtualFile.class;
            }
            case 1: {
                return this.getCommitColumnClass();
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + column + " > " + 3);
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }
}

