/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.ui.VcsStructureChooser;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StructureFilterPopupComponent
extends FilterPopupComponent<VcsLogStructureFilter> {
    public static final int FILTER_LABEL_LENGTH = 20;
    @NotNull
    private final Collection<VirtualFile> myRoots;
    @NotNull
    private final Collection<VirtualFile> myFiles;

    public StructureFilterPopupComponent(@NotNull VcsLogClassicFilterUi filterUi, @NotNull Collection<VirtualFile> roots) {
        if (filterUi == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "<init>"));
        }
        super(filterUi, "Structure");
        this.myRoots = roots;
        this.myFiles = ContainerUtil.newArrayList();
    }

    @Override
    protected ActionGroup createActionGroup() {
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectAction()});
    }

    @Override
    @Nullable
    protected VcsLogStructureFilter getFilter() {
        return this.getValue() == "All" || this.myFiles.isEmpty() ? null : new VcsLogStructureFilterImpl(this.myFiles, this.myRoots);
    }

    private void setValue(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "setValue"));
        }
        if (files.size() == 0) {
            this.setValue("All");
        } else if (files.size() == 1) {
            VirtualFile file = files.iterator().next();
            this.setValue(StringUtil.shortenPathWithEllipsis((String)file.getPresentableUrl(), (int)20), StructureFilterPopupComponent.getTooltip(files));
        } else {
            this.setValue(files.size() + " items", StructureFilterPopupComponent.getTooltip(files));
        }
    }

    @NotNull
    private static String getTooltip(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltip"));
        }
        List<Object> filesToDisplay = new ArrayList<VirtualFile>(files);
        if (files.size() > 10) {
            filesToDisplay = filesToDisplay.subList(0, 10);
        }
        String tooltip = StringUtil.join(filesToDisplay, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile file) {
                return file.getPresentableUrl();
            }
        }, (String)"\n");
        if (files.size() > 10) {
            tooltip = tooltip + "\n...";
        }
        String string = tooltip;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltip"));
        }
        return string;
    }

    @NotNull
    private static <T> Collection<T> notNullize(@Nullable Collection<T> items) {
        Collection<T> collection = items != null ? items : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "notNullize"));
        }
        return collection;
    }

    private class SelectAction
    extends DumbAwareAction {
        SelectAction() {
            super("Select...");
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            assert (project != null);
            VcsStructureChooser chooser = new VcsStructureChooser(project, "Select Files or Folders to Filter", StructureFilterPopupComponent.this.myFiles, new ArrayList<VirtualFile>(StructureFilterPopupComponent.this.myRoots));
            if (chooser.showAndGet()) {
                StructureFilterPopupComponent.this.myFiles.clear();
                StructureFilterPopupComponent.this.myFiles.addAll(StructureFilterPopupComponent.notNullize(chooser.getSelectedFiles()));
                StructureFilterPopupComponent.this.setValue(StructureFilterPopupComponent.this.myFiles);
                StructureFilterPopupComponent.this.applyFilters();
            }
        }
    }
}

