/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogBranchFilter> {
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private VcsLogDataPack myDataPack;

    public BranchFilterPopupComponent(@NotNull VcsLogClassicFilterUi filterUi, @NotNull VcsLogDataPack dataPack, @NotNull VcsLogUiProperties uiProperties) {
        if (filterUi == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "<init>"));
        }
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "<init>"));
        }
        super(filterUi, "Branch");
        this.myDataPack = dataPack;
        this.myUiProperties = uiProperties;
    }

    void updateDataPack(@NotNull DataPack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "updateDataPack"));
        }
        this.myDataPack = dataPack;
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(this.createAllAction());
        actionGroup.add(this.createSelectMultipleValuesAction());
        actionGroup.add((AnAction)BranchFilterPopupComponent.constructActionGroup(this.myDataPack, this.createRecentItemsActionGroup(), new Function<String, AnAction>(){

            public AnAction fun(String name) {
                return BranchFilterPopupComponent.this.createPredefinedValueAction(Collections.singleton(name));
            }
        }));
        return actionGroup;
    }

    public static ActionGroup constructActionGroup(@NotNull VcsLogDataPack dataPack, @Nullable ActionGroup recentItemsGroup, @NotNull Function<String, AnAction> actionGetter) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "constructActionGroup"));
        }
        if (actionGetter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "constructActionGroup"));
        }
        Groups groups = BranchFilterPopupComponent.prepareGroups(dataPack);
        return BranchFilterPopupComponent.getFilteredActionGroup(groups, recentItemsGroup, actionGetter);
    }

    private static Groups prepareGroups(@NotNull VcsLogDataPack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "prepareGroups"));
        }
        Groups filteredGroups = new Groups();
        Collection allRefs = dataPack.getRefs().getBranches();
        for (Map.Entry entry : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            Collection refs = (Collection)entry.getValue();
            VcsLogProvider provider = (VcsLogProvider)dataPack.getLogProviders().get(root);
            VcsLogRefManager refManager = provider.getReferenceManager();
            List refGroups = refManager.group(refs);
            BranchFilterPopupComponent.orderRefGroups(refGroups, filteredGroups);
        }
        return filteredGroups;
    }

    private static DefaultActionGroup getFilteredActionGroup(@NotNull Groups groups, @Nullable ActionGroup recentItems, @NotNull Function<String, AnAction> actionGetter) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getFilteredActionGroup"));
        }
        if (actionGetter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getFilteredActionGroup"));
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (String string : groups.singletonGroups) {
            actionGroup.add((AnAction)actionGetter.fun((Object)string));
        }
        if (recentItems != null) {
            actionGroup.add((AnAction)recentItems);
        }
        for (Map.Entry entry : groups.expandedGroups.entrySet()) {
            actionGroup.addSeparator((String)entry.getKey());
            for (String action : (TreeSet)entry.getValue()) {
                actionGroup.add((AnAction)actionGetter.fun((Object)action));
            }
        }
        actionGroup.addSeparator();
        for (Map.Entry entry : groups.collapsedGroups.entrySet()) {
            DefaultActionGroup popupGroup = new DefaultActionGroup((String)entry.getKey(), true);
            for (String action : (TreeSet)entry.getValue()) {
                popupGroup.add((AnAction)actionGetter.fun((Object)action));
            }
            actionGroup.add((AnAction)popupGroup);
        }
        return actionGroup;
    }

    private static void orderRefGroups(List<RefGroup> groups, Groups filteredGroups) {
        for (RefGroup group : groups) {
            if (group.getRefs().size() == 1) {
                String name = ((VcsRef)group.getRefs().iterator().next()).getName();
                if (filteredGroups.singletonGroups.contains(name)) continue;
                filteredGroups.singletonGroups.add(name);
                continue;
            }
            if (group.isExpanded()) {
                BranchFilterPopupComponent.addToGroup(group, filteredGroups.expandedGroups);
                continue;
            }
            BranchFilterPopupComponent.addToGroup(group, filteredGroups.collapsedGroups);
        }
    }

    private static void addToGroup(RefGroup group, TreeMap<String, TreeSet<String>> groupToAdd) {
        TreeSet<String> existingGroup = groupToAdd.get(group.getName());
        TreeSet<String> actions = new TreeSet<String>();
        for (VcsRef ref : group.getRefs()) {
            actions.add(ref.getName());
        }
        if (existingGroup == null) {
            groupToAdd.put(group.getName(), actions);
        } else {
            for (String action : actions) {
                existingGroup.add(action);
            }
        }
    }

    @Override
    @Nullable
    protected VcsLogBranchFilter getFilter() {
        if (this.getSelectedValues() == null) {
            return null;
        }
        return new VcsLogBranchFilterImpl(this.getSelectedValues());
    }

    @Override
    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        List<List<String>> list = this.myUiProperties.getRecentlyFilteredBranchGroups();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getRecentValuesFromSettings"));
        }
        return list;
    }

    @Override
    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "rememberValuesInSettings"));
        }
        if (values.size() > 1) {
            this.myUiProperties.addRecentlyFilteredBranchGroup(new ArrayList<String>(values));
        }
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        List list = ContainerUtil.map((Collection)this.myDataPack.getRefs().getBranches(), (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef ref) {
                return ref.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getAllValues"));
        }
        return list;
    }

    private static class Groups {
        private final TreeSet<String> singletonGroups = ContainerUtil.newTreeSet();
        private final TreeMap<String, TreeSet<String>> expandedGroups = ContainerUtil.newTreeMap();
        private final TreeMap<String, TreeSet<String>> collapsedGroups = ContainerUtil.newTreeMap();

        private Groups() {
        }
    }
}

