/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printmodel.layout;

import com.intellij.vcs.log.compressedlist.generator.AbstractGenerator;
import com.intellij.vcs.log.graph.Graph;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.GraphElement;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.elements.NodeRow;
import com.intellij.vcs.log.printmodel.layout.LayoutRow;
import com.intellij.vcs.log.printmodel.layout.MutableLayoutRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

class LayoutRowGenerator
extends AbstractGenerator<LayoutRow, MutableLayoutRow> {
    private final Graph graph;

    public LayoutRowGenerator(@NotNull Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/layout/LayoutRowGenerator", "<init>"));
        }
        this.graph = graph;
    }

    @Override
    @NotNull
    protected MutableLayoutRow createMutable(@NotNull LayoutRow cellRow) {
        if (cellRow == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/layout/LayoutRowGenerator", "createMutable"));
        }
        MutableLayoutRow mutableLayoutRow = new MutableLayoutRow(cellRow);
        if (mutableLayoutRow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/layout/LayoutRowGenerator", "createMutable"));
        }
        return mutableLayoutRow;
    }

    @NotNull
    private List<Edge> orderAddEdges(@NotNull List<Edge> edges) {
        if (edges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/layout/LayoutRowGenerator", "orderAddEdges"));
        }
        if (edges.size() <= 1) {
            List<Edge> list = edges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/layout/LayoutRowGenerator", "orderAddEdges"));
            }
            return list;
        }
        ArrayList<Edge> sortEdges = new ArrayList<Edge>(edges);
        Collections.sort(sortEdges, new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                if (o1.getDownNode().getRowIndex() > o2.getDownNode().getRowIndex()) {
                    return -1;
                }
                return 1;
            }
        });
        ArrayList<Edge> arrayList = sortEdges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/layout/LayoutRowGenerator", "orderAddEdges"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected MutableLayoutRow oneStep(@NotNull MutableLayoutRow row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/layout/LayoutRowGenerator", "oneStep"));
        }
        int newRowIndex = row.getGraphNodeRow().getRowIndex() + 1;
        if (newRowIndex == this.graph.getNodeRows().size()) {
            throw new NoSuchElementException();
        }
        List<GraphElement> layoutRow = row.getModifiableOrderedGraphElements();
        HashSet<Node> addedNodeInNextRow = new HashSet<Node>();
        ListIterator<GraphElement> iterator = layoutRow.listIterator();
        while (iterator.hasNext()) {
            GraphElement element = iterator.next();
            Node node = element.getNode();
            if (node != null) {
                List<Edge> edges = node.getDownEdges();
                if (edges.size() == 0) {
                    iterator.remove();
                    continue;
                }
                iterator.remove();
                for (Edge edge : this.orderAddEdges(edges)) {
                    Node downNode = edge.getDownNode();
                    if (downNode.getRowIndex() == newRowIndex) {
                        if (addedNodeInNextRow.contains(downNode)) continue;
                        iterator.add(downNode);
                        addedNodeInNextRow.add(downNode);
                        continue;
                    }
                    iterator.add(edge);
                }
                continue;
            }
            Edge edge = element.getEdge();
            if (edge == null) {
                throw new IllegalStateException("unexpected element class");
            }
            if (edge.getDownNode().getRowIndex() != newRowIndex) continue;
            if (!addedNodeInNextRow.contains(edge.getDownNode())) {
                iterator.set(edge.getDownNode());
                addedNodeInNextRow.add(edge.getDownNode());
                continue;
            }
            iterator.remove();
        }
        NodeRow nextGraphRow = this.graph.getNodeRows().get(newRowIndex);
        for (Node node : nextGraphRow.getNodes()) {
            if (!node.getUpEdges().isEmpty()) continue;
            layoutRow.add(node);
        }
        row.setNodeRow(nextGraphRow);
        MutableLayoutRow mutableLayoutRow = row;
        if (mutableLayoutRow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/layout/LayoutRowGenerator", "oneStep"));
        }
        return mutableLayoutRow;
    }

    @Override
    @NotNull
    public LayoutRow generateFirst() {
        List<NodeRow> rows = this.graph.getNodeRows();
        if (rows.isEmpty()) {
            MutableLayoutRow mutableLayoutRow = new MutableLayoutRow();
            if (mutableLayoutRow == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/layout/LayoutRowGenerator", "generateFirst"));
            }
            return mutableLayoutRow;
        }
        NodeRow firstRow = rows.get(0);
        MutableLayoutRow firstCellRow = new MutableLayoutRow();
        firstCellRow.setNodeRow(firstRow);
        List<GraphElement> editableLayoutRow = firstCellRow.getModifiableOrderedGraphElements();
        for (Node node : firstRow.getNodes()) {
            editableLayoutRow.add(node);
        }
        MutableLayoutRow mutableLayoutRow = firstCellRow;
        if (mutableLayoutRow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/layout/LayoutRowGenerator", "generateFirst"));
        }
        return mutableLayoutRow;
    }
}

