/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printmodel.impl;

import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.GraphElement;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.printmodel.CommitSelectController;
import com.intellij.vcs.log.printmodel.SelectController;
import com.intellij.vcs.log.printmodel.ShortEdge;
import com.intellij.vcs.log.printmodel.SpecialPrintElement;
import com.intellij.vcs.log.printmodel.impl.GraphElementsVisibilityController;
import com.intellij.vcs.log.printmodel.layout.LayoutModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class PrePrintCellModel {
    private final GraphElementsVisibilityController visibilityController;
    private List<GraphElement> visibleElementsInThisRow;
    private final int rowIndex;
    private final SelectController selectController;
    private final CommitSelectController commitSelectController;

    public PrePrintCellModel(boolean hideLongEdge, @NotNull LayoutModel layoutModel, int rowIndex, @NotNull SelectController selectController, CommitSelectController commitSelectController) {
        if (layoutModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/printmodel/impl/PrePrintCellModel", "<init>"));
        }
        if (selectController == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/printmodel/impl/PrePrintCellModel", "<init>"));
        }
        this.commitSelectController = commitSelectController;
        this.visibilityController = new GraphElementsVisibilityController(hideLongEdge, layoutModel);
        this.rowIndex = rowIndex;
        this.selectController = selectController;
        this.visibleElementsInThisRow = this.visibilityController.visibleElements(rowIndex);
    }

    public PrePrintCellModel(@NotNull LayoutModel layoutModel, int rowIndex, @NotNull SelectController selectController, CommitSelectController commitSelectController) {
        if (layoutModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/impl/PrePrintCellModel", "<init>"));
        }
        if (selectController == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/printmodel/impl/PrePrintCellModel", "<init>"));
        }
        this(true, layoutModel, rowIndex, selectController, commitSelectController);
    }

    public int getCountCells() {
        return this.visibleElementsInThisRow.size();
    }

    private boolean isMarked(Edge edge) {
        return this.commitSelectController.isSelected(edge.getUpNode()) && this.commitSelectController.isSelected(edge.getDownNode());
    }

    @NotNull
    public List<SpecialPrintElement> getSpecialPrintElements() {
        ArrayList<SpecialPrintElement> specialPrintElements = new ArrayList<SpecialPrintElement>();
        block6: for (int i = 0; i < this.visibleElementsInThisRow.size(); ++i) {
            GraphElement element = this.visibleElementsInThisRow.get(i);
            Node node = element.getNode();
            if (node != null) {
                if (node.getType() != Node.NodeType.COMMIT_NODE) continue;
                int dragAndDropSelect = 0;
                if (node == this.commitSelectController.getDragAndDropNode()) {
                    dragAndDropSelect = this.commitSelectController.isAbove() ? 1 : -1;
                }
                specialPrintElements.add(new SpecialPrintElement(node, i, SpecialPrintElement.Type.COMMIT_NODE, this.selectController.isSelected(node), this.commitSelectController.isSelected(node), dragAndDropSelect));
                continue;
            }
            Edge edge = element.getEdge();
            if (edge == null) {
                throw new IllegalStateException();
            }
            switch (this.visibilityController.visibilityTypeEdge(edge, this.rowIndex)) {
                case HIDE: {
                    continue block6;
                }
                case USUAL: {
                    continue block6;
                }
                case LAST_VISIBLE: {
                    specialPrintElements.add(new SpecialPrintElement(edge, i, SpecialPrintElement.Type.DOWN_ARROW, this.selectController.isSelected(edge), this.isMarked(edge), 0));
                    continue block6;
                }
                case FIRST_VISIBLE: {
                    specialPrintElements.add(new SpecialPrintElement(edge, i, SpecialPrintElement.Type.UP_ARROW, this.selectController.isSelected(edge), this.isMarked(edge), 0));
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        List<SpecialPrintElement> list = Collections.unmodifiableList(specialPrintElements);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/PrePrintCellModel", "getSpecialPrintElements"));
        }
        return list;
    }

    @NotNull
    public List<ShortEdge> downShortEdges() {
        int p;
        GetterGraphElementPosition getter = new GetterGraphElementPosition(this.visibilityController.visibleElements(this.rowIndex + 1));
        ArrayList<ShortEdge> shortEdges = new ArrayList<ShortEdge>();
        for (p = 0; p < this.visibleElementsInThisRow.size(); ++p) {
            Node node = this.visibleElementsInThisRow.get(p).getNode();
            if (node == null) continue;
            for (Edge edge : node.getDownEdges()) {
                int to = getter.getPosition(edge);
                assert (to != -1);
                shortEdges.add(new ShortEdge(edge, p, to, this.selectController.isSelected(edge), this.isMarked(edge)));
            }
        }
        for (p = 0; p < this.visibleElementsInThisRow.size(); ++p) {
            int to;
            Edge edge = this.visibleElementsInThisRow.get(p).getEdge();
            if (edge == null || (to = getter.getPosition(edge)) < 0) continue;
            shortEdges.add(new ShortEdge(edge, p, to, this.selectController.isSelected(edge), this.isMarked(edge)));
        }
        List<ShortEdge> list = Collections.unmodifiableList(shortEdges);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/PrePrintCellModel", "downShortEdges"));
        }
        return list;
    }

    private static class GetterGraphElementPosition {
        private final Map<GraphElement, Integer> mapNodes = new HashMap<GraphElement, Integer>();

        public GetterGraphElementPosition(List<GraphElement> graphElements) {
            this.mapNodes.clear();
            for (int p = 0; p < graphElements.size(); ++p) {
                this.mapNodes.put(graphElements.get(p), p);
            }
        }

        public int getPosition(Edge edge) {
            Integer p = this.mapNodes.get(edge);
            if (p == null) {
                p = this.mapNodes.get(edge.getDownNode());
            }
            if (p == null) {
                return -1;
            }
            return p;
        }
    }
}

