/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printmodel.impl;

import com.intellij.vcs.log.compressedlist.UpdateRequest;
import com.intellij.vcs.log.graph.Graph;
import com.intellij.vcs.log.printmodel.CommitSelectController;
import com.intellij.vcs.log.printmodel.GraphPrintCell;
import com.intellij.vcs.log.printmodel.GraphPrintCellModel;
import com.intellij.vcs.log.printmodel.SelectController;
import com.intellij.vcs.log.printmodel.ShortEdge;
import com.intellij.vcs.log.printmodel.SpecialPrintElement;
import com.intellij.vcs.log.printmodel.impl.PrePrintCellModel;
import com.intellij.vcs.log.printmodel.layout.LayoutModel;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphPrintCellModelImpl
implements GraphPrintCellModel {
    private final LayoutModel layoutModel;
    private final SelectController selectController;
    private boolean hideLongEdges = true;
    private final CommitSelectController commitSelectController;

    public GraphPrintCellModelImpl(Graph graph) {
        this.layoutModel = new LayoutModel(graph);
        this.selectController = new SelectController();
        this.commitSelectController = new CommitSelectController();
    }

    private List<ShortEdge> getUpEdges(int rowIndex) {
        PrePrintCellModel prevPreModel = new PrePrintCellModel(this.hideLongEdges, this.layoutModel, rowIndex - 1, this.selectController, this.commitSelectController);
        return prevPreModel.downShortEdges();
    }

    @Override
    public void recalculate(@NotNull UpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/impl/GraphPrintCellModelImpl", "recalculate"));
        }
        this.layoutModel.recalculate(updateRequest);
    }

    @Override
    public void setLongEdgeVisibility(boolean visibility) {
        this.hideLongEdges = !visibility;
    }

    @Override
    public boolean areLongEdgesHidden() {
        return this.hideLongEdges;
    }

    @Override
    @NotNull
    public SelectController getSelectController() {
        SelectController selectController = this.selectController;
        if (selectController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphPrintCellModelImpl", "getSelectController"));
        }
        return selectController;
    }

    @Override
    @NotNull
    public CommitSelectController getCommitSelectController() {
        CommitSelectController commitSelectController = this.commitSelectController;
        if (commitSelectController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphPrintCellModelImpl", "getCommitSelectController"));
        }
        return commitSelectController;
    }

    @Override
    @NotNull
    public GraphPrintCell getGraphPrintCell(final int rowIndex) {
        final PrePrintCellModel prePrintCellModel = new PrePrintCellModel(this.hideLongEdges, this.layoutModel, rowIndex, this.selectController, this.commitSelectController);
        GraphPrintCell graphPrintCell = new GraphPrintCell(){

            @Override
            public int countCell() {
                return prePrintCellModel.getCountCells();
            }

            @Override
            @NotNull
            public List<ShortEdge> getUpEdges() {
                List list = GraphPrintCellModelImpl.this.getUpEdges(rowIndex);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphPrintCellModelImpl$1", "getUpEdges"));
                }
                return list;
            }

            @Override
            @NotNull
            public List<ShortEdge> getDownEdges() {
                List<ShortEdge> list = prePrintCellModel.downShortEdges();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphPrintCellModelImpl$1", "getDownEdges"));
                }
                return list;
            }

            @Override
            @NotNull
            public List<SpecialPrintElement> getSpecialPrintElements() {
                List<SpecialPrintElement> list = prePrintCellModel.getSpecialPrintElements();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphPrintCellModelImpl$1", "getSpecialPrintElements"));
                }
                return list;
            }
        };
        if (graphPrintCell == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphPrintCellModelImpl", "getGraphPrintCell"));
        }
        return graphPrintCell;
    }
}

