/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printmodel.impl;

import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.GraphElement;
import com.intellij.vcs.log.printmodel.layout.LayoutModel;
import com.intellij.vcs.log.printmodel.layout.LayoutRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class GraphElementsVisibilityController {
    private static final int LONG_EDGE = 20;
    private static final int EDGE_PART_SHOW = 1;
    private static final boolean SHOW_ARROW_WHEN_SHOW_LONG_EDGES = true;
    private final LayoutModel layoutModel;
    private boolean hideLongEdge;

    public GraphElementsVisibilityController(boolean hideLongEdge, LayoutModel layoutModel) {
        this.hideLongEdge = hideLongEdge;
        this.layoutModel = layoutModel;
    }

    public void setHideLongEdge(boolean hideLongEdge) {
        this.hideLongEdge = hideLongEdge;
    }

    @NotNull
    public VisibilityType visibilityTypeEdge(Edge edge, int rowIndex) {
        if (!this.hideLongEdge) {
            // empty if block
        }
        int upRowIndex = edge.getUpNode().getRowIndex();
        int downRowIndex = edge.getDownNode().getRowIndex();
        if (downRowIndex - upRowIndex < 20) {
            VisibilityType visibilityType = VisibilityType.USUAL;
            if (visibilityType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphElementsVisibilityController", "visibilityTypeEdge"));
            }
            return visibilityType;
        }
        int upDelta = rowIndex - upRowIndex;
        int downDelta = downRowIndex - rowIndex;
        if (upDelta < 1 || downDelta < 1) {
            VisibilityType visibilityType = VisibilityType.USUAL;
            if (visibilityType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphElementsVisibilityController", "visibilityTypeEdge"));
            }
            return visibilityType;
        }
        if (upDelta == 1) {
            VisibilityType visibilityType = VisibilityType.LAST_VISIBLE;
            if (visibilityType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphElementsVisibilityController", "visibilityTypeEdge"));
            }
            return visibilityType;
        }
        if (downDelta == 1) {
            VisibilityType visibilityType = VisibilityType.FIRST_VISIBLE;
            if (visibilityType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphElementsVisibilityController", "visibilityTypeEdge"));
            }
            return visibilityType;
        }
        if (this.hideLongEdge) {
            VisibilityType visibilityType = VisibilityType.HIDE;
            if (visibilityType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphElementsVisibilityController", "visibilityTypeEdge"));
            }
            return visibilityType;
        }
        VisibilityType visibilityType = VisibilityType.USUAL;
        if (visibilityType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphElementsVisibilityController", "visibilityTypeEdge"));
        }
        return visibilityType;
    }

    @NotNull
    public List<GraphElement> visibleElements(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.layoutModel.getLayoutRows().size()) {
            List<GraphElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphElementsVisibilityController", "visibleElements"));
            }
            return list;
        }
        LayoutRow cellRow = this.layoutModel.getLayoutRows().get(rowIndex);
        List<GraphElement> cells = cellRow.getOrderedGraphElements();
        if (!this.hideLongEdge) {
            List<GraphElement> list = cells;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphElementsVisibilityController", "visibleElements"));
            }
            return list;
        }
        ArrayList<GraphElement> visibleElements = new ArrayList<GraphElement>();
        for (GraphElement cell : cells) {
            if (cell.getNode() != null) {
                visibleElements.add(cell);
                continue;
            }
            Edge edge = cell.getEdge();
            if (edge == null) {
                throw new IllegalStateException();
            }
            if (this.visibilityTypeEdge(edge, rowIndex) == VisibilityType.HIDE) continue;
            visibleElements.add(cell);
        }
        List<GraphElement> list = Collections.unmodifiableList(visibleElements);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/impl/GraphElementsVisibilityController", "visibleElements"));
        }
        return list;
    }

    public static enum VisibilityType {
        USUAL,
        LAST_VISIBLE,
        FIRST_VISIBLE,
        HIDE;

    }
}

