/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printmodel;

import com.intellij.vcs.log.graph.elements.Edge;
import org.jetbrains.annotations.NotNull;

public class ShortEdge {
    private final Edge edge;
    private final int upPosition;
    private final int downPosition;
    private final boolean selected;
    private final boolean marked;

    public ShortEdge(@NotNull Edge edge, int upPosition, int downPosition, boolean selected, boolean marked) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/ShortEdge", "<init>"));
        }
        this.edge = edge;
        this.upPosition = upPosition;
        this.downPosition = downPosition;
        this.selected = selected;
        this.marked = marked;
    }

    @NotNull
    public Edge getEdge() {
        Edge edge = this.edge;
        if (edge == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/ShortEdge", "getEdge"));
        }
        return edge;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public boolean isUsual() {
        return this.edge.getType() == Edge.EdgeType.USUAL;
    }

    public int getUpPosition() {
        return this.upPosition;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int getDownPosition() {
        return this.downPosition;
    }
}

