/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.render.cell;

import com.intellij.vcs.log.newgraph.gpaph.Node;
import com.intellij.vcs.log.newgraph.gpaph.impl.FilterMutableGraph;
import com.intellij.vcs.log.newgraph.render.GraphCellGenerator;
import com.intellij.vcs.log.newgraph.render.cell.GraphCell;
import com.intellij.vcs.log.newgraph.render.cell.GraphCellGeneratorImpl;
import com.intellij.vcs.log.newgraph.render.cell.SpecialRowElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class FilterGraphCellGenerator
implements GraphCellGenerator {
    @NotNull
    private final GraphCellGenerator myDelegateCellGenerator;
    @NotNull
    private final FilterMutableGraph myFilterMutableGraph;

    public FilterGraphCellGenerator(@NotNull FilterMutableGraph filterMutableGraph) {
        if (filterMutableGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/cell/FilterGraphCellGenerator", "<init>"));
        }
        this.myFilterMutableGraph = filterMutableGraph;
        this.myDelegateCellGenerator = new GraphCellGeneratorImpl(filterMutableGraph);
    }

    @Override
    public int getCountVisibleRow() {
        return this.myDelegateCellGenerator.getCountVisibleRow();
    }

    @Override
    public GraphCell getGraphCell(int visibleRowIndex) {
        GraphCell delegateCell = this.myDelegateCellGenerator.getGraphCell(visibleRowIndex);
        ArrayList<SpecialRowElement> newSpecialElements = new ArrayList<SpecialRowElement>();
        newSpecialElements.addAll(delegateCell.getSpecialRowElements());
        Node node = null;
        for (SpecialRowElement element : newSpecialElements) {
            if (element.getType() != SpecialRowElement.Type.NODE) continue;
            node = (Node)element.getElement();
        }
        assert (node != null);
        if (this.myFilterMutableGraph.nextRowIsHide(visibleRowIndex)) {
            newSpecialElements.add(new SpecialRowElement(node, 0, SpecialRowElement.Type.DOWN_HARMONICA));
        }
        return new GraphCell(delegateCell.getCountElements(), newSpecialElements, delegateCell.getUpEdges(), delegateCell.getDownEdges());
    }

    @Override
    public boolean isShowLongEdges() {
        return this.myDelegateCellGenerator.isShowLongEdges();
    }

    @Override
    public void setShowLongEdges(boolean showLongEdges) {
        this.myDelegateCellGenerator.setShowLongEdges(showLongEdges);
    }

    @Override
    public void invalidate() {
        this.myDelegateCellGenerator.invalidate();
    }
}

