/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.render.cell;

import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.MutableGraph;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EdgesInRow {
    private static final int CACHE_SIZE = 100;
    private static final int WALK_SIZE = 1000;
    @NotNull
    private final MutableGraph myGraph;
    @NotNull
    private final SLRUMap<Integer, Set<Edge>> cache;

    public EdgesInRow(@NotNull MutableGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/cell/EdgesInRow", "<init>"));
        }
        this.cache = new SLRUMap(100, 200);
        this.myGraph = graph;
    }

    @NotNull
    public Set<Edge> getEdgesInRow(int visibleRowIndex) {
        Set edges = (Set)this.cache.get((Object)visibleRowIndex);
        if (edges != null) {
            Set set = edges;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/cell/EdgesInRow", "getEdgesInRow"));
            }
            return set;
        }
        Set<Edge> set = this.calculateEdgesAround(visibleRowIndex);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/cell/EdgesInRow", "getEdgesInRow"));
        }
        return set;
    }

    public void invalidate() {
        this.cache.clear();
    }

    @NotNull
    private Set<Edge> calculateEdgesAround(int visibleRowIndex) {
        int i;
        int startIndex = Math.max(visibleRowIndex - 50, 0);
        int endIndex = Math.min(visibleRowIndex + 50, this.myGraph.getCountVisibleNodes() - 1);
        List<Set<Edge>> uCorrectEdges = this.getUCorrectEdges(startIndex, endIndex);
        List<Set<Edge>> dCorrectEdges = this.getDCorrectEdges(startIndex, endIndex);
        assert (uCorrectEdges.size() == dCorrectEdges.size());
        for (i = 0; i < uCorrectEdges.size(); ++i) {
            uCorrectEdges.get(i).addAll((Collection<Edge>)dCorrectEdges.get(i));
        }
        for (i = 0; i < uCorrectEdges.size(); ++i) {
            this.cache.put((Object)(startIndex + i), uCorrectEdges.get(i));
        }
        Set<Edge> set = uCorrectEdges.get(visibleRowIndex - startIndex);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/cell/EdgesInRow", "calculateEdgesAround"));
        }
        return set;
    }

    @NotNull
    private List<Set<Edge>> getUCorrectEdges(int startIndex, int endIndex) {
        int startCalculateIndex = Math.max(startIndex - 1000, 0);
        ArrayList<Set<Edge>> result = new ArrayList<Set<Edge>>(endIndex - startIndex + 1);
        Node currentNode = this.myGraph.getNode(startCalculateIndex);
        HashSet<Edge> edgesInCurrentRow = new HashSet<Edge>();
        if (startCalculateIndex >= startIndex) {
            result.add(new HashSet(edgesInCurrentRow));
        }
        for (int i = startCalculateIndex + 1; i <= endIndex; ++i) {
            Node nextNode = this.myGraph.getNode(i);
            EdgesInRow.oneDownStep(edgesInCurrentRow, currentNode, nextNode);
            if (i >= startIndex) {
                result.add(new HashSet<Edge>(edgesInCurrentRow));
            }
            currentNode = nextNode;
        }
        ArrayList<Set<Edge>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/cell/EdgesInRow", "getUCorrectEdges"));
        }
        return arrayList;
    }

    private static void oneDownStep(Set<Edge> edgesInCurrentRow, Node currentNode, Node nextNode) {
        edgesInCurrentRow.addAll(currentNode.getDownEdges());
        edgesInCurrentRow.removeAll(nextNode.getUpEdges());
    }

    @NotNull
    private List<Set<Edge>> getDCorrectEdges(int startIndex, int endIndex) {
        int endCalculateIndex = Math.min(endIndex + 1000, this.myGraph.getCountVisibleNodes() - 1);
        ArrayList<Set<Edge>> result = new ArrayList<Set<Edge>>(endIndex - startIndex + 1);
        Node currentNode = this.myGraph.getNode(endCalculateIndex);
        HashSet<Edge> edgesInCurrentRow = new HashSet<Edge>();
        if (endCalculateIndex <= endIndex) {
            result.add(new HashSet(edgesInCurrentRow));
        }
        for (int i = endCalculateIndex - 1; i >= startIndex; --i) {
            Node prevNode = this.myGraph.getNode(i);
            EdgesInRow.oneUpStep(edgesInCurrentRow, currentNode, prevNode);
            if (i <= endIndex) {
                result.add(new HashSet<Edge>(edgesInCurrentRow));
            }
            currentNode = prevNode;
        }
        Collections.reverse(result);
        ArrayList<Set<Edge>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/cell/EdgesInRow", "getDCorrectEdges"));
        }
        return arrayList;
    }

    private static void oneUpStep(Set<Edge> edgesInCurrentRow, Node currentNode, Node prevNode) {
        edgesInCurrentRow.addAll(currentNode.getUpEdges());
        edgesInCurrentRow.removeAll(prevNode.getDownEdges());
    }
}

