/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.render;

import com.intellij.ui.JBColor;
import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.GraphElement;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import com.intellij.vcs.log.newgraph.gpaph.ThickHoverController;
import com.intellij.vcs.log.newgraph.render.ElementColorManager;
import com.intellij.vcs.log.newgraph.render.GraphCellPainter;
import com.intellij.vcs.log.newgraph.render.PositionUtil;
import com.intellij.vcs.log.newgraph.render.cell.GraphCell;
import com.intellij.vcs.log.newgraph.render.cell.ShortEdge;
import com.intellij.vcs.log.newgraph.render.cell.SpecialRowElement;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGraphCellPainter
implements GraphCellPainter {
    private static final Color MARK_COLOR = JBColor.BLACK;
    private final Stroke usual;
    private final Stroke hide;
    private final Stroke selectUsual;
    private final Stroke selectHide;
    private Graphics2D g2;
    @NotNull
    private final ThickHoverController myThickHoverController;
    @NotNull
    private final ElementColorManager myColorManager;

    public SimpleGraphCellPainter(@NotNull ThickHoverController thickHoverController, @NotNull ElementColorManager colorManager) {
        if (thickHoverController == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "<init>"));
        }
        this.usual = new BasicStroke(1.5f, 1, 2);
        this.hide = new BasicStroke(1.5f, 1, 2, 0.0f, new float[]{7.0f}, 0.0f);
        this.selectUsual = new BasicStroke(2.5f, 1, 2);
        this.selectHide = new BasicStroke(2.5f, 1, 2, 0.0f, new float[]{7.0f}, 0.0f);
        this.myThickHoverController = thickHoverController;
        this.myColorManager = colorManager;
    }

    private void paintUpLine(int from, int to, Color color) {
        int x1 = 15 * from + 7;
        int y1 = 11;
        int x2 = 15 * to + 7;
        int y2 = -11;
        this.g2.setColor(color);
        this.g2.drawLine(x2, y2, x1, y1);
    }

    private void paintDownLine(int from, int to, Color color) {
        int x1 = 15 * from + 7;
        int y1 = 11;
        int x2 = 15 * to + 7;
        int y2 = 33;
        this.g2.setColor(color);
        this.g2.drawLine(x1, y1, x2, y2);
    }

    private void paintAbove(int position, Color color) {
        int x1 = 15 * position + 3;
        int y = 4;
        int x2 = 15 * position + 15 - 4;
        this.g2.setColor(color);
        this.g2.drawLine(x1, y, x2, y);
    }

    private void paintBelow(int position, Color color) {
        int x1 = 15 * position + 3;
        int y = 18;
        int x2 = 15 * position + 15 - 4;
        this.g2.setColor(color);
        this.g2.drawLine(x1, y, x2, y);
    }

    private void paintCircle(int position, Color color, boolean select) {
        int x0 = 15 * position + 7;
        int y0 = 11;
        int r = 4;
        if (select) {
            r = 5;
        }
        Ellipse2D.Double circle = new Ellipse2D.Double((double)(x0 - r) + 0.5, (double)(y0 - r) + 0.5, 2 * r, 2 * r);
        this.g2.setColor(color);
        this.g2.fill(circle);
    }

    private void paintHide(int position, Color color) {
        int x0 = 15 * position + 7;
        int y0 = 11;
        int r = 4;
        this.g2.setColor(color);
        this.g2.drawLine(x0, y0, x0, y0 + r);
        this.g2.drawLine(x0, y0 + r, x0 + r, y0);
        this.g2.drawLine(x0, y0 + r, x0 - r, y0);
    }

    private void paintShow(int position, Color color) {
        int x0 = 15 * position + 7;
        int y0 = 11;
        int r = 4;
        this.g2.setColor(color);
        this.g2.drawLine(x0, y0, x0, y0 - r);
        this.g2.drawLine(x0, y0 - r, x0 + r, y0);
        this.g2.drawLine(x0, y0 - r, x0 - r, y0);
    }

    private void paintDownHarmonica(Color color) {
        int x0 = 0;
        int y0 = 21;
        this.g2.setColor(color);
        this.g2.drawLine(x0, y0, x0 + 7, y0);
    }

    private void setStroke(boolean usual, boolean select) {
        if (usual) {
            if (select) {
                this.g2.setStroke(this.selectUsual);
            } else {
                this.g2.setStroke(this.usual);
            }
        } else if (select) {
            this.g2.setStroke(this.selectHide);
        } else {
            this.g2.setStroke(this.hide);
        }
    }

    private void drawLogic(boolean selected, boolean marked, boolean isUsual, Color usualColor, LitePrinter printer) {
        if (marked) {
            this.setStroke(isUsual, true);
            printer.print(MARK_COLOR);
            this.setStroke(isUsual, false);
            printer.print(usualColor);
        } else {
            this.setStroke(isUsual, selected);
            printer.print(usualColor);
        }
    }

    private boolean isSelected(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "isSelected"));
        }
        return this.myThickHoverController.isThick(graphElement);
    }

    private boolean isMarked(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "isMarked"));
        }
        return this.myThickHoverController.isHover(graphElement);
    }

    private static boolean isUsual(@NotNull Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "isUsual"));
        }
        return edge.getType() == Edge.Type.USUAL;
    }

    @NotNull
    private JBColor getColor(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "getColor"));
        }
        JBColor jBColor = this.myColorManager.getColor(element);
        if (jBColor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "getColor"));
        }
        return jBColor;
    }

    private boolean isMarked(@NotNull SpecialRowElement specialRowElement) {
        if (specialRowElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "isMarked"));
        }
        return this.myThickHoverController.isHover(specialRowElement) || this.myThickHoverController.isHover(specialRowElement.getElement());
    }

    @Override
    public void draw(@NotNull Graphics2D g2, @NotNull GraphCell row) {
        Edge edge;
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "draw"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "draw"));
        }
        this.g2 = g2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (final ShortEdge shortEdge : row.getUpEdges()) {
            edge = shortEdge.getEdge();
            this.drawLogic(this.isSelected(edge), this.isMarked(edge), SimpleGraphCellPainter.isUsual(edge), (Color)this.getColor(edge), new LitePrinter(){

                @Override
                public void print(Color color) {
                    SimpleGraphCellPainter.this.paintUpLine(shortEdge.getDownPosition(), shortEdge.getUpPosition(), color);
                }
            });
        }
        for (final ShortEdge shortEdge : row.getDownEdges()) {
            edge = shortEdge.getEdge();
            this.drawLogic(this.isSelected(edge), this.isMarked(edge), SimpleGraphCellPainter.isUsual(edge), (Color)this.getColor(edge), new LitePrinter(){

                @Override
                public void print(Color color) {
                    SimpleGraphCellPainter.this.paintDownLine(shortEdge.getUpPosition(), shortEdge.getDownPosition(), color);
                }
            });
        }
        block8: for (final SpecialRowElement rowElement : row.getSpecialRowElements()) {
            GraphElement element = rowElement.getElement();
            switch (rowElement.getType()) {
                case NODE: {
                    assert (element instanceof Node);
                    Node node = (Node)element;
                    if (this.isMarked(node)) {
                        this.paintCircle(rowElement.getPosition(), MARK_COLOR, true);
                        this.paintCircle(rowElement.getPosition(), (Color)this.getColor(node), false);
                        continue block8;
                    }
                    this.paintCircle(rowElement.getPosition(), (Color)this.getColor(node), this.isSelected(node));
                    continue block8;
                }
                case UP_ARROW: {
                    assert (element instanceof Edge);
                    Edge edge2 = (Edge)element;
                    this.drawLogic(this.isSelected(edge2), this.isMarked(rowElement), SimpleGraphCellPainter.isUsual(edge2), (Color)this.getColor(edge2), new LitePrinter(){

                        @Override
                        public void print(Color color) {
                            SimpleGraphCellPainter.this.paintShow(rowElement.getPosition(), color);
                        }
                    });
                    continue block8;
                }
                case DOWN_ARROW: {
                    assert (element instanceof Edge);
                    Edge edge2 = (Edge)element;
                    this.drawLogic(this.isSelected(edge2), this.isMarked(rowElement), SimpleGraphCellPainter.isUsual(edge2), (Color)this.getColor(edge2), new LitePrinter(){

                        @Override
                        public void print(Color color) {
                            SimpleGraphCellPainter.this.paintHide(rowElement.getPosition(), color);
                        }
                    });
                    continue block8;
                }
                case DOWN_HARMONICA: {
                    this.drawLogic(true, false, true, (Color)JBColor.BLACK, new LitePrinter(){

                        @Override
                        public void print(Color color) {
                        }
                    });
                    continue block8;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    @Nullable
    public GraphElement mouseOver(@NotNull GraphCell graphCell, int x, int y) {
        if (graphCell == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "mouseOver"));
        }
        for (SpecialRowElement printElement : graphCell.getSpecialRowElements()) {
            if (printElement.getType() != SpecialRowElement.Type.NODE || !PositionUtil.overNode(printElement.getPosition(), x, y)) continue;
            return printElement.getElement();
        }
        for (ShortEdge edge : graphCell.getUpEdges()) {
            if (!PositionUtil.overUpEdge(edge, x, y)) continue;
            return edge.getEdge();
        }
        for (ShortEdge edge : graphCell.getDownEdges()) {
            if (!PositionUtil.overDownEdge(edge, x, y)) continue;
            return edge.getEdge();
        }
        return null;
    }

    @Override
    @Nullable
    public SpecialRowElement mouseOverArrow(@NotNull GraphCell graphCell, int x, int y) {
        if (graphCell == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/SimpleGraphCellPainter", "mouseOverArrow"));
        }
        for (SpecialRowElement rowElement : graphCell.getSpecialRowElements()) {
            if (rowElement.getType() != SpecialRowElement.Type.UP_ARROW && rowElement.getType() != SpecialRowElement.Type.DOWN_ARROW || !PositionUtil.overNode(rowElement.getPosition(), x, y)) continue;
            return rowElement;
        }
        return null;
    }

    private static interface LitePrinter {
        public void print(Color var1);
    }
}

