/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.render;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.graph.PaintInfo;
import com.intellij.vcs.log.newgraph.gpaph.MutableGraph;
import com.intellij.vcs.log.newgraph.render.ElementColorManager;
import com.intellij.vcs.log.newgraph.render.GraphCellGenerator;
import com.intellij.vcs.log.newgraph.render.GraphCellPainter;
import com.intellij.vcs.log.newgraph.render.SimpleGraphCellPainter;
import com.intellij.vcs.log.newgraph.render.cell.GraphCell;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;

public class GraphRender {
    @NotNull
    private final GraphCellGenerator myCellGenerator;
    @NotNull
    private final GraphCellPainter myCellPainter;

    public GraphRender(@NotNull MutableGraph mutableGraph, @NotNull ElementColorManager colorManager, @NotNull GraphCellGenerator cellGenerator) {
        if (mutableGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/GraphRender", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/render/GraphRender", "<init>"));
        }
        if (cellGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/render/GraphRender", "<init>"));
        }
        this.myCellGenerator = cellGenerator;
        this.myCellPainter = new SimpleGraphCellPainter(mutableGraph.getThickHoverController(), colorManager);
    }

    @NotNull
    public PaintInfo paint(int visibleRowIndex) {
        Pair<Integer, Integer> imageAndBufferImageWidth = this.getImageAndBufferImageWidth(visibleRowIndex);
        BufferedImage image = UIUtil.createImage((int)((Integer)imageAndBufferImageWidth.getSecond()), (int)22, (int)2);
        Graphics2D g2 = image.createGraphics();
        GraphCell graphCell = this.myCellGenerator.getGraphCell(visibleRowIndex);
        this.myCellPainter.draw(g2, graphCell);
        PaintInfoImpl paintInfoImpl = new PaintInfoImpl(image, (Integer)imageAndBufferImageWidth.getFirst());
        if (paintInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/GraphRender", "paint"));
        }
        return paintInfoImpl;
    }

    public boolean isShowLongEdges() {
        return this.myCellGenerator.isShowLongEdges();
    }

    public void setShowLongEdges(boolean longEdgesHidden) {
        this.myCellGenerator.setShowLongEdges(longEdgesHidden);
    }

    public void invalidate() {
        this.myCellGenerator.invalidate();
    }

    @NotNull
    public GraphCellGenerator getCellGenerator() {
        GraphCellGenerator graphCellGenerator = this.myCellGenerator;
        if (graphCellGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/GraphRender", "getCellGenerator"));
        }
        return graphCellGenerator;
    }

    @NotNull
    public GraphCellPainter getCellPainter() {
        GraphCellPainter graphCellPainter = this.myCellPainter;
        if (graphCellPainter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/GraphRender", "getCellPainter"));
        }
        return graphCellPainter;
    }

    @NotNull
    private Pair<Integer, Integer> getImageAndBufferImageWidth(int visibleRowIndex) {
        int imageWidth = this.calcImageWidth(visibleRowIndex);
        int bufferWidth = this.calcMaxImageWith(visibleRowIndex);
        if (bufferWidth > imageWidth + 30) {
            imageWidth += (bufferWidth - imageWidth) / 4;
        }
        Pair pair = new Pair((Object)imageWidth, (Object)bufferWidth);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/GraphRender", "getImageAndBufferImageWidth"));
        }
        return pair;
    }

    private int calcImageWidth(int visibleRowIndex) {
        return this.myCellGenerator.getGraphCell(visibleRowIndex).getCountElements() * 15;
    }

    private int calcMaxImageWith(int visibleRowIndex) {
        int maxElementsCount = this.myCellGenerator.getGraphCell(visibleRowIndex).getCountElements();
        if (visibleRowIndex > 0) {
            maxElementsCount = Math.max(maxElementsCount, this.myCellGenerator.getGraphCell(visibleRowIndex - 1).getCountElements());
        }
        if (visibleRowIndex < this.myCellGenerator.getCountVisibleRow() - 1) {
            maxElementsCount = Math.max(maxElementsCount, this.myCellGenerator.getGraphCell(visibleRowIndex + 1).getCountElements());
        }
        return 15 * maxElementsCount;
    }

    private static class PaintInfoImpl
    implements PaintInfo {
        private final Image myImage;
        private final int myWidth;

        public PaintInfoImpl(Image image, int width) {
            this.myImage = image;
            this.myWidth = width;
        }

        @NotNull
        public Image getImage() {
            Image image = this.myImage;
            if (image == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/GraphRender$PaintInfoImpl", "getImage"));
            }
            return image;
        }

        public int getWidth() {
            return this.myWidth;
        }
    }
}

