/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.impl;

import com.intellij.vcs.log.newgraph.PermanentGraph;
import com.intellij.vcs.log.newgraph.PermanentGraphLayout;
import com.intellij.vcs.log.newgraph.utils.DfsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PermanentGraphLayoutBuilder {
    private final PermanentGraph myGraph;
    private final int[] myLayoutIndex;
    private final List<Integer> myHeadNodeIndex;
    private final int[] myStartLayoutIndexForHead;
    private final DfsUtil myDfsUtil;
    private int currentLayoutIndex = 1;

    @NotNull
    public static PermanentGraphLayout build(@NotNull DfsUtil dfsUtil, @NotNull PermanentGraph graph, @NotNull Comparator<Integer> compareTwoHeaderNodeIndex) {
        if (dfsUtil == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/impl/PermanentGraphLayoutBuilder", "build"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/impl/PermanentGraphLayoutBuilder", "build"));
        }
        if (compareTwoHeaderNodeIndex == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/impl/PermanentGraphLayoutBuilder", "build"));
        }
        ArrayList<Integer> heads = new ArrayList<Integer>();
        for (int i = 0; i < graph.nodesCount(); ++i) {
            if (graph.getUpNodes(i).size() != 0) continue;
            heads.add(i);
        }
        Collections.sort(heads, compareTwoHeaderNodeIndex);
        PermanentGraphLayoutBuilder builder = new PermanentGraphLayoutBuilder(graph, heads, dfsUtil);
        PermanentGraphLayout permanentGraphLayout = builder.build();
        if (permanentGraphLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/impl/PermanentGraphLayoutBuilder", "build"));
        }
        return permanentGraphLayout;
    }

    private PermanentGraphLayoutBuilder(PermanentGraph graph, List<Integer> headNodeIndex, DfsUtil dfsUtil) {
        this.myGraph = graph;
        this.myDfsUtil = dfsUtil;
        this.myLayoutIndex = new int[graph.nodesCount()];
        this.myHeadNodeIndex = headNodeIndex;
        this.myStartLayoutIndexForHead = new int[headNodeIndex.size()];
    }

    private void dfs(int nodeIndex) {
        this.myDfsUtil.nodeDfsIterator(nodeIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                boolean firstVisit;
                boolean bl = firstVisit = PermanentGraphLayoutBuilder.this.myLayoutIndex[currentNode] == 0;
                if (firstVisit) {
                    ((PermanentGraphLayoutBuilder)PermanentGraphLayoutBuilder.this).myLayoutIndex[currentNode] = PermanentGraphLayoutBuilder.this.currentLayoutIndex;
                }
                int childWithoutLayoutIndex = -1;
                for (int childNodeIndex : PermanentGraphLayoutBuilder.this.myGraph.getDownNodes(currentNode)) {
                    if (childNodeIndex == Integer.MAX_VALUE || PermanentGraphLayoutBuilder.this.myLayoutIndex[childNodeIndex] != 0) continue;
                    childWithoutLayoutIndex = childNodeIndex;
                    break;
                }
                if (childWithoutLayoutIndex == -1) {
                    if (firstVisit) {
                        PermanentGraphLayoutBuilder.this.currentLayoutIndex++;
                    }
                    return -1;
                }
                return childWithoutLayoutIndex;
            }
        });
    }

    @NotNull
    private PermanentGraphLayout build() {
        for (int i = 0; i < this.myHeadNodeIndex.size(); ++i) {
            int headNodeIndex = this.myHeadNodeIndex.get(i);
            this.myStartLayoutIndexForHead[i] = this.currentLayoutIndex;
            this.dfs(headNodeIndex);
        }
        PermanentGraphLayoutImpl permanentGraphLayoutImpl = new PermanentGraphLayoutImpl(this.myLayoutIndex, this.myHeadNodeIndex, this.myStartLayoutIndexForHead);
        if (permanentGraphLayoutImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/impl/PermanentGraphLayoutBuilder", "build"));
        }
        return permanentGraphLayoutImpl;
    }

    private static class PermanentGraphLayoutImpl
    implements PermanentGraphLayout {
        private final int[] myLayoutIndex;
        private final List<Integer> myHeadNodeIndex;
        private final int[] myStartLayoutIndexForHead;

        private PermanentGraphLayoutImpl(int[] layoutIndex, List<Integer> headNodeIndex, int[] startLayoutIndexForHead) {
            this.myLayoutIndex = layoutIndex;
            this.myHeadNodeIndex = headNodeIndex;
            this.myStartLayoutIndexForHead = startLayoutIndexForHead;
        }

        @Override
        public int getLayoutIndex(int nodeIndex) {
            return this.myLayoutIndex[nodeIndex];
        }

        @Override
        public int getOneOfHeadNodeIndex(int nodeIndex) {
            return this.getHeadNodeIndex(this.getLayoutIndex(nodeIndex));
        }

        @Override
        public int getHeadNodeIndex(int layoutIndex) {
            return this.myHeadNodeIndex.get(this.getHeadOrder(layoutIndex));
        }

        private int getHeadOrder(int layoutIndex) {
            int a = 0;
            int b = this.myStartLayoutIndexForHead.length - 1;
            while (b > a) {
                int middle = (a + b + 1) / 2;
                if (this.myStartLayoutIndexForHead[middle] <= layoutIndex) {
                    a = middle;
                    continue;
                }
                b = middle - 1;
            }
            return a;
        }

        @Override
        public int getStartLayout(int layoutIndex) {
            return this.myStartLayoutIndexForHead[this.getHeadOrder(layoutIndex)];
        }
    }
}

