/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.impl;

import com.intellij.util.SmartList;
import com.intellij.vcs.log.newgraph.PermanentGraph;
import com.intellij.vcs.log.newgraph.utils.Flags;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PermanentGraphImpl
implements PermanentGraph {
    private final Flags mySimpleNodes;
    private final int[] myNodeToHashIndex;
    private final int[] myNodeToEdgeIndex;
    private final int[] myLongEdges;

    PermanentGraphImpl(Flags simpleNodes, int[] nodeToHashIndex, int[] nodeToEdgeIndex, int[] longEdges) {
        this.mySimpleNodes = simpleNodes;
        this.myNodeToHashIndex = nodeToHashIndex;
        this.myNodeToEdgeIndex = nodeToEdgeIndex;
        this.myLongEdges = longEdges;
    }

    @Override
    public int nodesCount() {
        return this.mySimpleNodes.size();
    }

    @NotNull
    private List<Integer> adjacentNodes(final int nodeIndex) {
        final int startIndex = this.myNodeToEdgeIndex[nodeIndex];
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return PermanentGraphImpl.this.myLongEdges[startIndex + index];
            }

            @Override
            public int size() {
                return PermanentGraphImpl.this.myNodeToEdgeIndex[nodeIndex + 1] - startIndex;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/impl/PermanentGraphImpl", "adjacentNodes"));
        }
        return abstractList;
    }

    @Override
    @NotNull
    public List<Integer> getUpNodes(int nodeIndex) {
        SmartList result = new SmartList();
        if (nodeIndex != 0 && this.mySimpleNodes.get(nodeIndex - 1)) {
            result.add(nodeIndex - 1);
        }
        for (Integer node : this.adjacentNodes(nodeIndex)) {
            if (node >= nodeIndex) continue;
            result.add(node);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/impl/PermanentGraphImpl", "getUpNodes"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<Integer> getDownNodes(int nodeIndex) {
        if (this.mySimpleNodes.get(nodeIndex)) {
            List<Integer> list = Collections.singletonList(nodeIndex + 1);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/impl/PermanentGraphImpl", "getDownNodes"));
            }
            return list;
        }
        SmartList result = new SmartList();
        for (Integer node : this.adjacentNodes(nodeIndex)) {
            if (nodeIndex >= node) continue;
            result.add(node);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/impl/PermanentGraphImpl", "getDownNodes"));
        }
        return smartList;
    }

    @Override
    public int getHashIndex(int nodeIndex) {
        if (nodeIndex == this.nodesCount()) {
            return Integer.MIN_VALUE;
        }
        return this.myNodeToHashIndex[nodeIndex];
    }
}

