/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.GraphCommit;
import com.intellij.vcs.log.newgraph.impl.DuplicateParentFixer;
import com.intellij.vcs.log.newgraph.impl.PermanentGraphImpl;
import com.intellij.vcs.log.newgraph.utils.Flags;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PermanentGraphBuilder {
    private final List<? extends GraphCommit> myCommits;
    private final Flags mySimpleNodes;
    private final int myNodesCount;
    private final int[] myNodeToHashIndex;
    private final int[] myNodeToEdgeIndex;
    private final int[] myLongEdges;
    private final Map<Integer, List<Integer>> upAdjacentNodes = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, GraphCommit> commitsWithNotLoadParentMap = new HashMap<Integer, GraphCommit>();

    @NotNull
    public static Pair<PermanentGraphImpl, Map<Integer, GraphCommit>> build(@NotNull Flags simpleNodes, @NotNull List<? extends GraphCommit> commits) {
        if (simpleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/impl/PermanentGraphBuilder", "build"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/impl/PermanentGraphBuilder", "build"));
        }
        commits = DuplicateParentFixer.fixDuplicateParentCommits(commits);
        assert (commits.size() == simpleNodes.size());
        int longEdgesCount = 0;
        int[] nodeToHashIndex = new int[commits.size()];
        for (int nodeIndex = 0; nodeIndex < commits.size(); ++nodeIndex) {
            GraphCommit commit = commits.get(nodeIndex);
            nodeToHashIndex[nodeIndex] = commit.getIndex();
            int nextCommitHashIndex = PermanentGraphBuilder.nextCommitHashIndex(commits, nodeIndex);
            int[] parentHashIndices = commit.getParentIndices();
            if (parentHashIndices.length == 1 && parentHashIndices[0] == nextCommitHashIndex) {
                simpleNodes.set(nodeIndex, true);
                continue;
            }
            longEdgesCount += parentHashIndices.length;
        }
        PermanentGraphBuilder builder = new PermanentGraphBuilder(commits, simpleNodes, longEdgesCount, nodeToHashIndex);
        PermanentGraphImpl permanentGraph = builder.build();
        Pair pair = new Pair((Object)permanentGraph, builder.commitsWithNotLoadParentMap);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/impl/PermanentGraphBuilder", "build"));
        }
        return pair;
    }

    private static int nextCommitHashIndex(List<? extends GraphCommit> commits, int nodeIndex) {
        int nextCommitHashIndex = -1;
        if (nodeIndex < commits.size() - 1) {
            nextCommitHashIndex = commits.get(nodeIndex + 1).getIndex();
        }
        return nextCommitHashIndex;
    }

    private PermanentGraphBuilder(List<? extends GraphCommit> commits, Flags simpleNodes, int longEdgesCount, int[] nodeToHashIndex) {
        this.myCommits = commits;
        this.mySimpleNodes = simpleNodes;
        this.myNodeToHashIndex = nodeToHashIndex;
        this.myNodesCount = simpleNodes.size();
        this.myNodeToEdgeIndex = new int[this.myNodesCount + 1];
        this.myLongEdges = new int[2 * longEdgesCount];
    }

    private void addUnderdoneEdge(int upNodeIndex, int downHashIndex) {
        SmartList upNodes = this.upAdjacentNodes.get(downHashIndex);
        if (upNodes == null) {
            upNodes = new SmartList();
            this.upAdjacentNodes.put(downHashIndex, (List<Integer>)upNodes);
        }
        upNodes.add(upNodeIndex);
    }

    private void addCommitWithNotLoadParent(int nodeIndex) {
        GraphCommit commit = this.myCommits.get(nodeIndex);
        this.commitsWithNotLoadParentMap.put(commit.getIndex(), commit);
    }

    private void fixUnderdoneEdgeForNotLoadCommit(int upNodeIndex) {
        for (int edgeIndex = this.myNodeToEdgeIndex[upNodeIndex]; edgeIndex < this.myNodeToEdgeIndex[upNodeIndex + 1]; ++edgeIndex) {
            if (this.myLongEdges[edgeIndex] != -1) continue;
            this.addCommitWithNotLoadParent(upNodeIndex);
            this.myLongEdges[edgeIndex] = Integer.MAX_VALUE;
            return;
        }
        throw new IllegalStateException("Not found underdone edge to not load commit for node: " + upNodeIndex);
    }

    private void fixUnderdoneEdge(int upNodeIndex, int downNodeIndex, int downNodeHashIndex) {
        int end = this.myNodeToEdgeIndex[upNodeIndex + 1];
        GraphCommit upCommit = this.myCommits.get(upNodeIndex);
        int[] parentHashIndices = upCommit.getParentIndices();
        for (int i = 0; i < parentHashIndices.length; ++i) {
            if (parentHashIndices[i] != downNodeHashIndex) continue;
            int offset = parentHashIndices.length - i;
            int edgeIndex = end - offset;
            if (this.myLongEdges[edgeIndex] == -1) {
                this.myLongEdges[edgeIndex] = downNodeIndex;
                return;
            }
            throw new IllegalStateException("Edge was set early!. Up node: " + upNodeIndex + ", down node: " + downNodeIndex);
        }
        throw new IllegalStateException("Not found underdone edges for node: " + upNodeIndex + ". Adjacent down node: " + downNodeIndex);
    }

    private void doStep(int nodeIndex) {
        GraphCommit commit = this.myCommits.get(nodeIndex);
        List<Integer> upNodes = this.upAdjacentNodes.remove(commit.getIndex());
        if (upNodes == null) {
            upNodes = Collections.emptyList();
        }
        int edgeIndex = this.myNodeToEdgeIndex[nodeIndex];
        for (Integer upNodeIndex : upNodes) {
            this.fixUnderdoneEdge(upNodeIndex, nodeIndex, commit.getIndex());
            this.myLongEdges[edgeIndex] = upNodeIndex;
            ++edgeIndex;
        }
        if (!this.mySimpleNodes.get(nodeIndex)) {
            int[] arr$ = commit.getParentIndices();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer downHashIndex = arr$[i$];
                this.addUnderdoneEdge(nodeIndex, downHashIndex);
                this.myLongEdges[edgeIndex] = -1;
                ++edgeIndex;
            }
        }
        this.myNodeToEdgeIndex[nodeIndex + 1] = edgeIndex;
    }

    private void fixUnderdoneEdges() {
        for (List<Integer> upNodes : this.upAdjacentNodes.values()) {
            for (Integer upNodeIndex : upNodes) {
                this.fixUnderdoneEdgeForNotLoadCommit(upNodeIndex);
            }
        }
    }

    private PermanentGraphImpl build() {
        for (int nodeIndex = 0; nodeIndex < this.myNodesCount; ++nodeIndex) {
            this.doStep(nodeIndex);
        }
        this.fixUnderdoneEdges();
        return new PermanentGraphImpl(this.mySimpleNodes, this.myNodeToHashIndex, this.myNodeToEdgeIndex, this.myLongEdges);
    }
}

