/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.gpaph.impl;

import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import com.intellij.vcs.log.newgraph.PermanentGraph;
import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.GraphElement;
import com.intellij.vcs.log.newgraph.gpaph.MutableGraph;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import com.intellij.vcs.log.newgraph.gpaph.actions.InternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.actions.MouseOverGraphElementInternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.actions.SelectAllRelativeCommitsInternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.fragments.FragmentGenerator;
import com.intellij.vcs.log.newgraph.gpaph.fragments.GraphFragment;
import com.intellij.vcs.log.newgraph.gpaph.impl.AbstractThickHoverController;
import com.intellij.vcs.log.newgraph.gpaph.impl.MutableGraphWithHiddenNodes;
import com.intellij.vcs.log.newgraph.utils.DfsUtil;
import com.intellij.vcs.log.newgraph.utils.Flags;
import com.intellij.vcs.log.newgraph.utils.MyUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ThickHoverControllerImpl
extends AbstractThickHoverController {
    @NotNull
    private final PermanentGraph myPermanentGraph;
    @NotNull
    private final MutableGraph myMutableGraph;
    @NotNull
    private final FragmentGenerator myFragmentGenerator;
    @NotNull
    private final Set<Integer> hoverNodes;
    @NotNull
    private final Flags myThickFlags;
    @NotNull
    private final DfsUtil myDfsUtil;

    public ThickHoverControllerImpl(@NotNull PermanentGraph permanentGraph, @NotNull MutableGraph mutableGraph, @NotNull FragmentGenerator fragmentGenerator, @NotNull Flags thickFlags, @NotNull DfsUtil dfsUtil) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "<init>"));
        }
        if (mutableGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "<init>"));
        }
        if (fragmentGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "<init>"));
        }
        if (thickFlags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "<init>"));
        }
        if (dfsUtil == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "<init>"));
        }
        this.hoverNodes = new HashSet();
        this.myPermanentGraph = permanentGraph;
        this.myMutableGraph = mutableGraph;
        this.myFragmentGenerator = fragmentGenerator;
        this.myThickFlags = thickFlags;
        this.myDfsUtil = dfsUtil;
    }

    @Override
    public boolean isThick(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "isThick"));
        }
        return ThickHoverControllerImpl.isOn(element, new Function<Integer, Boolean>(){

            public Boolean fun(Integer integer) {
                return ThickHoverControllerImpl.this.myThickFlags.get(ThickHoverControllerImpl.this.myMutableGraph.getIndexInPermanentGraph(integer));
            }
        });
    }

    @Override
    public boolean isHover(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "isHover"));
        }
        return ThickHoverControllerImpl.isOn(element, new Function<Integer, Boolean>(){

            public Boolean fun(Integer integer) {
                return ThickHoverControllerImpl.this.hoverNodes.contains(integer);
            }
        });
    }

    private static boolean isOn(@NotNull GraphElement element, @NotNull Function<Integer, Boolean> visibleNodeIndexToOn) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "isOn"));
        }
        if (visibleNodeIndexToOn == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "isOn"));
        }
        if (element instanceof Node) {
            return (Boolean)visibleNodeIndexToOn.fun((Object)((Node)element).getVisibleNodeIndex());
        }
        if (element instanceof Edge) {
            Edge edge = (Edge)element;
            int visibleUpNodeIndex = edge.getUpNodeVisibleIndex();
            int visibleDownNodeIndex = edge.getDownNodeVisibleIndex();
            if (visibleDownNodeIndex == Integer.MAX_VALUE) {
                return false;
            }
            return (Boolean)visibleNodeIndexToOn.fun((Object)visibleUpNodeIndex) != false && (Boolean)visibleNodeIndexToOn.fun((Object)visibleDownNodeIndex) != false;
        }
        return false;
    }

    @Override
    public void performAction(@NotNull InternalGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "performAction"));
        }
        super.performAction(action);
        if (action instanceof SelectAllRelativeCommitsInternalGraphAction) {
            MyUtils.setAllValues(this.myThickFlags, false);
            Integer visibleNodeIndex = (Integer)((SelectAllRelativeCommitsInternalGraphAction)action).getInfo();
            if (visibleNodeIndex != null) {
                int realRowIndex = this.myMutableGraph.getIndexInPermanentGraph(visibleNodeIndex);
                this.enableAllRelativeNodes(this.myThickFlags, realRowIndex);
            }
        }
        if (action instanceof MouseOverGraphElementInternalGraphAction) {
            this.hoverNodes.clear();
            GraphElement graphElement = (GraphElement)((MouseOverGraphElementInternalGraphAction)action).getInfo();
            if (graphElement != null) {
                this.hoverFragment(graphElement);
            }
        }
    }

    private void enableAllRelativeNodes(final @NotNull Flags flags, int rowIndex) {
        if (flags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "enableAllRelativeNodes"));
        }
        flags.set(rowIndex, true);
        this.myDfsUtil.nodeDfsIterator(rowIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                for (int downNode : ThickHoverControllerImpl.this.myPermanentGraph.getDownNodes(currentNode)) {
                    if (downNode == Integer.MAX_VALUE || flags.get(downNode)) continue;
                    flags.set(downNode, true);
                    return downNode;
                }
                return -1;
            }
        });
        this.myDfsUtil.nodeDfsIterator(rowIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                for (int upNode : ThickHoverControllerImpl.this.myPermanentGraph.getUpNodes(currentNode)) {
                    if (flags.get(upNode)) continue;
                    flags.set(upNode, true);
                    return upNode;
                }
                return -1;
            }
        });
    }

    private void hoverFragment(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/ThickHoverControllerImpl", "hoverFragment"));
        }
        Edge collapsedEdge = MutableGraphWithHiddenNodes.containedCollapsedEdge(graphElement);
        if (collapsedEdge != null) {
            this.hoverNodes.add(collapsedEdge.getUpNodeVisibleIndex());
            this.hoverNodes.add(collapsedEdge.getDownNodeVisibleIndex());
            return;
        }
        GraphFragment fragment = this.myFragmentGenerator.getPartLongFragment(graphElement);
        if (fragment == null) {
            return;
        }
        this.hoverNodes.add(fragment.upVisibleNodeIndex);
        this.hoverNodes.add(fragment.downVisibleNodeIndex);
        this.myDfsUtil.nodeDfsIterator(fragment.upVisibleNodeIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                for (Edge downEdge : ThickHoverControllerImpl.this.myMutableGraph.getNode(currentNode).getDownEdges()) {
                    int downNode = downEdge.getDownNodeVisibleIndex();
                    if (!ThickHoverControllerImpl.this.hoverNodes.add(downNode)) continue;
                    return downNode;
                }
                return -1;
            }
        });
    }
}

