/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.gpaph.impl;

import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeImpl
implements Node {
    private final int myVisibleNodeIndex;
    @NotNull
    private final Node.Type myType;
    @NotNull
    private final List<Edge> myUpEdges;
    @NotNull
    private final List<Edge> myDownEdges;
    private final int myLayoutIndex;

    public NodeImpl(int visibleNodeIndex, @NotNull Node.Type type, @NotNull List<Edge> upEdges, @NotNull List<Edge> downEdges, int layoutIndex) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/impl/NodeImpl", "<init>"));
        }
        if (upEdges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/gpaph/impl/NodeImpl", "<init>"));
        }
        if (downEdges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/newgraph/gpaph/impl/NodeImpl", "<init>"));
        }
        this.myVisibleNodeIndex = visibleNodeIndex;
        this.myType = type;
        this.myUpEdges = upEdges;
        this.myDownEdges = downEdges;
        this.myLayoutIndex = layoutIndex;
    }

    @Override
    public int getVisibleNodeIndex() {
        return this.myVisibleNodeIndex;
    }

    @Override
    @NotNull
    public Node.Type getType() {
        Node.Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/NodeImpl", "getType"));
        }
        return type;
    }

    @Override
    @NotNull
    public List<Edge> getUpEdges() {
        List<Edge> list = this.myUpEdges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/NodeImpl", "getUpEdges"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Edge> getDownEdges() {
        List<Edge> list = this.myDownEdges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/NodeImpl", "getDownEdges"));
        }
        return list;
    }

    @Override
    public int getLayoutIndex() {
        return this.myLayoutIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeImpl)) {
            return false;
        }
        NodeImpl node = (NodeImpl)o;
        if (this.myLayoutIndex != node.myLayoutIndex) {
            return false;
        }
        if (this.myVisibleNodeIndex != node.myVisibleNodeIndex) {
            return false;
        }
        return this.myType == node.myType;
    }

    public int hashCode() {
        int result = this.myVisibleNodeIndex;
        result = 31 * result + this.myType.hashCode();
        result = 31 * result + this.myLayoutIndex;
        return result;
    }
}

