/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.gpaph.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.BooleanFunction;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.newgraph.PermanentGraph;
import com.intellij.vcs.log.newgraph.PermanentGraphLayout;
import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.GraphWithElementsInfo;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import com.intellij.vcs.log.newgraph.gpaph.ThickHoverController;
import com.intellij.vcs.log.newgraph.gpaph.actions.InternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.impl.FilterThickHoverController;
import com.intellij.vcs.log.newgraph.gpaph.impl.MutableGraphWithHiddenNodes;
import com.intellij.vcs.log.newgraph.utils.Flags;
import com.intellij.vcs.log.newgraph.utils.IntToIntMap;
import com.intellij.vcs.log.newgraph.utils.impl.TreeIntToIntMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FilterMutableGraph
extends MutableGraphWithHiddenNodes<GraphWithElementsInfoImpl> {
    private static final Logger LOG = Logger.getInstance(FilterMutableGraph.class);
    @NotNull
    private final Flags myVisibleNodes;
    @NotNull
    private final PermanentGraph myPermanentGraph;
    @NotNull
    private final Condition<Integer> isVisibleNode;
    @NotNull
    private final FilterThickHoverController myThickHoverController;
    @NotNull
    private final TreeIntToIntMap myTreeVisibleToReal;

    public static FilterMutableGraph newInstance(@NotNull PermanentGraph permanentGraph, @NotNull PermanentGraphLayout layout, @NotNull Flags visibleNodesInBranches, final @NotNull Flags visibleNodes, @NotNull Condition<Integer> isVisibleNode) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "newInstance"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "newInstance"));
        }
        if (visibleNodesInBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "newInstance"));
        }
        if (visibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "newInstance"));
        }
        if (isVisibleNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "newInstance"));
        }
        for (int i = 0; i < permanentGraph.nodesCount(); ++i) {
            if (isVisibleNode.value((Object)i) && !visibleNodesInBranches.get(i)) {
                LOG.debug("Filter give me commit, which hidden in current branches visibility; commitHashIndex: " + permanentGraph.getHashIndex(i));
            }
            visibleNodes.set(i, isVisibleNode.value((Object)i));
        }
        TreeIntToIntMap visibleToReal = TreeIntToIntMap.newInstance(new BooleanFunction<Integer>(){

            public boolean fun(Integer integer) {
                return visibleNodes.get(integer);
            }
        }, permanentGraph.nodesCount());
        return new FilterMutableGraph(permanentGraph, layout, isVisibleNode, visibleToReal, visibleNodes);
    }

    private FilterMutableGraph(@NotNull PermanentGraph permanentGraph, @NotNull PermanentGraphLayout layout, @NotNull Condition<Integer> isVisibleNode, @NotNull TreeIntToIntMap visibleToReal, @NotNull Flags visibleNodes) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "<init>"));
        }
        if (isVisibleNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "<init>"));
        }
        if (visibleToReal == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "<init>"));
        }
        if (visibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "<init>"));
        }
        super(visibleToReal, new GraphWithElementsInfoImpl(permanentGraph, visibleNodes, visibleToReal), layout);
        this.myTreeVisibleToReal = visibleToReal;
        this.myVisibleNodes = visibleNodes;
        this.myPermanentGraph = permanentGraph;
        this.isVisibleNode = isVisibleNode;
        this.myThickHoverController = new FilterThickHoverController();
    }

    @Override
    public int performAction(@NotNull InternalGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "performAction"));
        }
        this.myThickHoverController.performAction(action);
        return -1;
    }

    public boolean nextRowIsHide(int visibleRowIndex) {
        int realIndex = this.myVisibleToReal.getLongIndex(visibleRowIndex);
        return realIndex < this.myPermanentGraph.nodesCount() - 1 && !this.myVisibleNodes.get(realIndex + 1);
    }

    private void showHideFragment(int visibleRowIndex) {
        int endIndex;
        int startIndex = this.myVisibleToReal.getLongIndex(visibleRowIndex);
        for (endIndex = startIndex + 1; endIndex < this.myPermanentGraph.nodesCount() && !this.myVisibleNodes.get(endIndex); ++endIndex) {
            this.myVisibleNodes.set(endIndex, true);
        }
        if (endIndex == this.myPermanentGraph.nodesCount()) {
            --endIndex;
        }
        this.myTreeVisibleToReal.update(startIndex, endIndex);
    }

    @Override
    @NotNull
    public ThickHoverController getThickHoverController() {
        FilterThickHoverController filterThickHoverController = this.myThickHoverController;
        if (filterThickHoverController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph", "getThickHoverController"));
        }
        return filterThickHoverController;
    }

    protected static class GraphWithElementsInfoImpl
    implements GraphWithElementsInfo {
        private final PermanentGraph myGraph;
        private final Flags myVisibleNodes;
        private final IntToIntMap myIntToIntMap;

        private GraphWithElementsInfoImpl(PermanentGraph graph, Flags visibleNodes, IntToIntMap intToIntMap) {
            this.myGraph = graph;
            this.myVisibleNodes = visibleNodes;
            this.myIntToIntMap = intToIntMap;
        }

        @Override
        @NotNull
        public Node.Type getNodeType(int nodeIndex) {
            Node.Type type = Node.Type.USUAL;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph$GraphWithElementsInfoImpl", "getNodeType"));
            }
            return type;
        }

        @Override
        @NotNull
        public Edge.Type getEdgeType(int upNodeIndex, int downNodeIndex) {
            Edge.Type type = Edge.Type.USUAL;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph$GraphWithElementsInfoImpl", "getEdgeType"));
            }
            return type;
        }

        @Override
        public int nodesCount() {
            return this.myIntToIntMap.shortSize();
        }

        @Override
        @NotNull
        public List<Integer> getUpNodes(int nodeIndex) {
            SmartList result = new SmartList();
            for (int upNode : this.myGraph.getUpNodes(nodeIndex)) {
                if (!this.myVisibleNodes.get(upNode)) continue;
                result.add(upNode);
            }
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph$GraphWithElementsInfoImpl", "getUpNodes"));
            }
            return smartList;
        }

        @Override
        @NotNull
        public List<Integer> getDownNodes(int nodeIndex) {
            SmartList result = new SmartList();
            for (int downNode : this.myGraph.getDownNodes(nodeIndex)) {
                if (downNode == Integer.MAX_VALUE || !this.myVisibleNodes.get(downNode)) continue;
                result.add(downNode);
            }
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/FilterMutableGraph$GraphWithElementsInfoImpl", "getDownNodes"));
            }
            return smartList;
        }
    }
}

