/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.gpaph.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.util.BooleanFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.vcs.log.newgraph.GraphFlags;
import com.intellij.vcs.log.newgraph.PermanentGraph;
import com.intellij.vcs.log.newgraph.PermanentGraphLayout;
import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.GraphElement;
import com.intellij.vcs.log.newgraph.gpaph.GraphWithElementsInfo;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import com.intellij.vcs.log.newgraph.gpaph.ThickHoverController;
import com.intellij.vcs.log.newgraph.gpaph.actions.ClickInternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.actions.InternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.actions.LinearBranchesExpansionInternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.fragments.FragmentGenerator;
import com.intellij.vcs.log.newgraph.gpaph.fragments.GraphFragment;
import com.intellij.vcs.log.newgraph.gpaph.impl.AbstractThickHoverController;
import com.intellij.vcs.log.newgraph.gpaph.impl.MutableGraphWithHiddenNodes;
import com.intellij.vcs.log.newgraph.gpaph.impl.ThickHoverControllerImpl;
import com.intellij.vcs.log.newgraph.utils.DfsUtil;
import com.intellij.vcs.log.newgraph.utils.Flags;
import com.intellij.vcs.log.newgraph.utils.MyUtils;
import com.intellij.vcs.log.newgraph.utils.impl.TreeIntToIntMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CollapsedMutableGraph
extends MutableGraphWithHiddenNodes<GraphWithElementsInfoImpl> {
    @NotNull
    private final FragmentGenerator myFragmentGenerator;
    @NotNull
    private final AbstractThickHoverController myThickHoverController;

    public static CollapsedMutableGraph newInstance(@NotNull PermanentGraph permanentGraph, @NotNull PermanentGraphLayout layout, @NotNull GraphFlags graphFlags, @NotNull Set<Integer> branchNodeIndexes, @NotNull DfsUtil dfsUtil) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "newInstance"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "newInstance"));
        }
        if (graphFlags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "newInstance"));
        }
        if (branchNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "newInstance"));
        }
        if (dfsUtil == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "newInstance"));
        }
        final Flags visibleNodes = graphFlags.getVisibleNodes();
        final Flags visibleNodesInBranches = graphFlags.getVisibleNodesInBranches();
        MyUtils.setAllValues(visibleNodes, true);
        TreeIntToIntMap intToIntMap = TreeIntToIntMap.newInstance(new BooleanFunction<Integer>(){

            public boolean fun(Integer integer) {
                return visibleNodes.get(integer) && visibleNodesInBranches.get(integer);
            }
        }, permanentGraph.nodesCount());
        GraphWithElementsInfoImpl graphWithElementsInfo = new GraphWithElementsInfoImpl(permanentGraph, visibleNodesInBranches, visibleNodes, intToIntMap, dfsUtil);
        return new CollapsedMutableGraph(permanentGraph, layout, intToIntMap, graphFlags.getThickFlags(), dfsUtil, branchNodeIndexes, graphWithElementsInfo);
    }

    private CollapsedMutableGraph(@NotNull PermanentGraph permanentGraph, @NotNull PermanentGraphLayout layout, @NotNull TreeIntToIntMap intToIntMap, @NotNull Flags thickFlags, @NotNull DfsUtil dfsUtil, @NotNull Set<Integer> branchNodeIndexes, @NotNull GraphWithElementsInfoImpl graphWithElementsInfo) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "<init>"));
        }
        if (intToIntMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "<init>"));
        }
        if (thickFlags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "<init>"));
        }
        if (dfsUtil == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "<init>"));
        }
        if (branchNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "<init>"));
        }
        if (graphWithElementsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "<init>"));
        }
        super(intToIntMap, graphWithElementsInfo, layout);
        this.myFragmentGenerator = new FragmentGenerator(this, branchNodeIndexes);
        this.myThickHoverController = new ThickHoverControllerImpl(permanentGraph, this, this.myFragmentGenerator, thickFlags, dfsUtil);
    }

    @Override
    public int performAction(@NotNull InternalGraphAction action) {
        GraphElement element;
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "performAction"));
        }
        this.myThickHoverController.performAction(action);
        if (action instanceof ClickInternalGraphAction && (element = (GraphElement)((ClickInternalGraphAction)action).getInfo()) != null) {
            Edge edge = CollapsedMutableGraph.containedCollapsedEdge(element);
            if (edge != null) {
                ((GraphWithElementsInfoImpl)this.myGraph).expand(this.getIndexInPermanentGraph(edge.getUpNodeVisibleIndex()), this.getIndexInPermanentGraph(edge.getDownNodeVisibleIndex()));
                return edge.getUpNodeVisibleIndex();
            }
            GraphFragment fragment = this.myFragmentGenerator.getLongFragment(element);
            if (fragment != null) {
                ((GraphWithElementsInfoImpl)this.myGraph).collapse(this.getIndexInPermanentGraph(fragment.upVisibleNodeIndex), this.getIndexInPermanentGraph(fragment.downVisibleNodeIndex));
                return fragment.upVisibleNodeIndex;
            }
        }
        if (action instanceof LinearBranchesExpansionInternalGraphAction) {
            Boolean info = (Boolean)((LinearBranchesExpansionInternalGraphAction)action).getInfo();
            assert (info != null);
            boolean shouldExpand = info;
            if (shouldExpand) {
                ((GraphWithElementsInfoImpl)this.myGraph).expandAll();
            } else {
                for (int currentVisibleIndex = 0; currentVisibleIndex < this.getCountVisibleNodes(); ++currentVisibleIndex) {
                    GraphFragment fragment = this.myFragmentGenerator.getLongDownFragment(currentVisibleIndex);
                    if (fragment == null) continue;
                    ((GraphWithElementsInfoImpl)this.myGraph).collapse(this.getIndexInPermanentGraph(fragment.upVisibleNodeIndex), this.getIndexInPermanentGraph(fragment.downVisibleNodeIndex));
                }
            }
            return 1;
        }
        return -1;
    }

    @NotNull
    public GraphWithElementsInfo getInternalGraph() {
        GraphWithElementsInfo graphWithElementsInfo = this.myGraph;
        if (graphWithElementsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "getInternalGraph"));
        }
        return graphWithElementsInfo;
    }

    @Override
    @NotNull
    public ThickHoverController getThickHoverController() {
        AbstractThickHoverController abstractThickHoverController = this.myThickHoverController;
        if (abstractThickHoverController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph", "getThickHoverController"));
        }
        return abstractThickHoverController;
    }

    protected static class GraphWithElementsInfoImpl
    implements GraphWithElementsInfo {
        @NotNull
        private final PermanentGraph myPermanentGraph;
        @NotNull
        private final Flags visibleNodesInBranches;
        @NotNull
        private final Flags visibleNodes;
        @NotNull
        private final TreeIntToIntMap intToIntMap;
        @NotNull
        private final DfsUtil myDfsUtil;
        @NotNull
        private final Map<Integer, Pair<Integer, Integer>> upToEdge;
        @NotNull
        private final Map<Integer, Pair<Integer, Integer>> downToEdge;

        public GraphWithElementsInfoImpl(@NotNull PermanentGraph permanentGraph, @NotNull Flags visibleNodesInBranches, @NotNull Flags visibleNodes, @NotNull TreeIntToIntMap intToIntMap, @NotNull DfsUtil dfsUtil) {
            if (permanentGraph == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "<init>"));
            }
            if (visibleNodesInBranches == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "<init>"));
            }
            if (visibleNodes == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "<init>"));
            }
            if (intToIntMap == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "<init>"));
            }
            if (dfsUtil == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "<init>"));
            }
            this.upToEdge = new HashMap();
            this.downToEdge = new HashMap();
            this.myPermanentGraph = permanentGraph;
            this.visibleNodesInBranches = visibleNodesInBranches;
            this.visibleNodes = visibleNodes;
            this.intToIntMap = intToIntMap;
            this.myDfsUtil = dfsUtil;
        }

        public void collapse(int upNodeIndex, final int downNodeIndex) {
            Pair edge = Pair.create((Object)upNodeIndex, (Object)downNodeIndex);
            this.myDfsUtil.nodeDfsIterator(upNodeIndex, new DfsUtil.NextNode(){

                @Override
                public int fun(int currentNode) {
                    if (GraphWithElementsInfoImpl.this.upToEdge.containsKey(currentNode)) {
                        Pair edge = (Pair)GraphWithElementsInfoImpl.this.upToEdge.remove(currentNode);
                        GraphWithElementsInfoImpl.this.downToEdge.remove(edge.second);
                        if ((Integer)edge.second == downNodeIndex) {
                            return -1;
                        }
                        GraphWithElementsInfoImpl.this.visibleNodes.set((Integer)edge.second, false);
                        return (Integer)edge.second;
                    }
                    for (int downNode : GraphWithElementsInfoImpl.this.myPermanentGraph.getDownNodes(currentNode)) {
                        if (!GraphWithElementsInfoImpl.this.visibleNodes.get(downNode) || downNode == downNodeIndex) continue;
                        GraphWithElementsInfoImpl.this.visibleNodes.set(downNode, false);
                        return downNode;
                    }
                    return -1;
                }
            });
            this.upToEdge.put(upNodeIndex, (Pair<Integer, Integer>)edge);
            this.downToEdge.put(downNodeIndex, (Pair<Integer, Integer>)edge);
            this.intToIntMap.update(upNodeIndex, downNodeIndex);
        }

        public void expand(int upNodeIndex, final int downNodeIndex) {
            this.upToEdge.remove(upNodeIndex);
            this.downToEdge.remove(downNodeIndex);
            this.myDfsUtil.nodeDfsIterator(upNodeIndex, new DfsUtil.NextNode(){

                @Override
                public int fun(int currentNode) {
                    for (int downNode : GraphWithElementsInfoImpl.this.myPermanentGraph.getDownNodes(currentNode)) {
                        if (GraphWithElementsInfoImpl.this.visibleNodes.get(downNode) || downNode == downNodeIndex) continue;
                        GraphWithElementsInfoImpl.this.visibleNodes.set(downNode, true);
                        return downNode;
                    }
                    return -1;
                }
            });
            this.intToIntMap.update(upNodeIndex, downNodeIndex);
        }

        public boolean nodeIsVisible(int nodeIndex) {
            if (nodeIndex == Integer.MAX_VALUE) {
                return true;
            }
            return this.visibleNodes.get(nodeIndex) && this.visibleNodesInBranches.get(nodeIndex);
        }

        public void expandAll() {
            this.upToEdge.clear();
            this.downToEdge.clear();
            MyUtils.setAllValues(this.visibleNodes, true);
            this.intToIntMap.update(0, this.myPermanentGraph.nodesCount() - 1);
        }

        @Override
        @NotNull
        public Node.Type getNodeType(int nodeIndex) {
            Node.Type type = Node.Type.USUAL;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "getNodeType"));
            }
            return type;
        }

        @Override
        @NotNull
        public Edge.Type getEdgeType(int upNodeIndex, int downNodeIndex) {
            if (this.upToEdge.containsKey(upNodeIndex)) {
                Edge.Type type = Edge.Type.HIDE_FRAGMENT;
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "getEdgeType"));
                }
                return type;
            }
            Edge.Type type = Edge.Type.USUAL;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "getEdgeType"));
            }
            return type;
        }

        @Override
        public int nodesCount() {
            return this.intToIntMap.shortSize();
        }

        @Override
        @NotNull
        public List<Integer> getUpNodes(int nodeIndex) {
            Pair<Integer, Integer> edge = this.downToEdge.get(nodeIndex);
            if (edge != null) {
                List<Object> list = Collections.singletonList(edge.first);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "getUpNodes"));
                }
                return list;
            }
            SmartList upNodes = new SmartList();
            for (int upNode : this.myPermanentGraph.getUpNodes(nodeIndex)) {
                if (!this.nodeIsVisible(upNode)) continue;
                upNodes.add(upNode);
            }
            SmartList smartList = upNodes;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "getUpNodes"));
            }
            return smartList;
        }

        @Override
        @NotNull
        public List<Integer> getDownNodes(int nodeIndex) {
            Pair<Integer, Integer> edge = this.upToEdge.get(nodeIndex);
            if (edge != null) {
                List<Object> list = Collections.singletonList(edge.second);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "getDownNodes"));
                }
                return list;
            }
            SmartList downNodes = new SmartList();
            for (int downNode : this.myPermanentGraph.getDownNodes(nodeIndex)) {
                if (!this.nodeIsVisible(downNode)) continue;
                downNodes.add(downNode);
            }
            SmartList smartList = downNodes;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/CollapsedMutableGraph$GraphWithElementsInfoImpl", "getDownNodes"));
            }
            return smartList;
        }
    }
}

