/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph;

import com.intellij.vcs.log.newgraph.utils.Flags;

public class GraphFlags {
    private final int myNodesCount;
    private final byte[] myFlags;

    public GraphFlags(int nodesCount) {
        this.myNodesCount = nodesCount;
        this.myFlags = new byte[nodesCount];
    }

    private Flags getFlags(int offset) {
        assert (offset >= 0 && offset < 8);
        final int mask = 1 << offset;
        return new Flags(){

            @Override
            public int size() {
                return GraphFlags.this.myNodesCount;
            }

            @Override
            public boolean get(int index) {
                return (GraphFlags.this.myFlags[index] & mask) != 0;
            }

            @Override
            public void set(int index, boolean value) {
                if (value) {
                    byte[] byArray = GraphFlags.this.myFlags;
                    int n = index;
                    byArray[n] = (byte)(byArray[n] | mask);
                } else {
                    byte[] byArray = GraphFlags.this.myFlags;
                    int n = index;
                    byArray[n] = (byte)(byArray[n] & ~mask);
                }
            }
        };
    }

    public Flags getVisibleNodes() {
        return this.getFlags(1);
    }

    public Flags getVisibleNodesInBranches() {
        return this.getFlags(3);
    }

    public Flags getSimpleNodeFlags() {
        return this.getFlags(0);
    }

    public Flags getThickFlags() {
        return this.getFlags(2);
    }

    public Flags getFlagsForFilters() {
        return this.getFlags(4);
    }

    public Flags getTempFlags() {
        return this.getFlags(5);
    }
}

