/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.TimedVcsCommitImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsShortCommitDetailsImpl
implements VcsShortCommitDetails {
    @NotNull
    private final TimedVcsCommit myTimeCommitParents;
    @NotNull
    private final String mySubject;
    @NotNull
    private final VcsUser myAuthor;
    @NotNull
    private final VirtualFile myRoot;

    /*
     * WARNING - void declaration
     */
    public VcsShortCommitDetailsImpl(@NotNull Hash hash, @NotNull List<Hash> parents, long timeStamp, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser vcsUser) {
        void author;
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsShortCommitDetailsImpl", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsShortCommitDetailsImpl", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/impl/VcsShortCommitDetailsImpl", "<init>"));
        }
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/impl/VcsShortCommitDetailsImpl", "<init>"));
        }
        if (vcsUser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/vcs/log/impl/VcsShortCommitDetailsImpl", "<init>"));
        }
        this.myTimeCommitParents = new TimedVcsCommitImpl(hash, parents, timeStamp);
        this.myRoot = root;
        this.mySubject = subject;
        this.myAuthor = author;
    }

    @NotNull
    public Hash getHash() {
        Hash hash = this.myTimeCommitParents.getHash();
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsShortCommitDetailsImpl", "getHash"));
        }
        return hash;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsShortCommitDetailsImpl", "getRoot"));
        }
        return virtualFile;
    }

    @NotNull
    public List<Hash> getParents() {
        List list = this.myTimeCommitParents.getParents();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsShortCommitDetailsImpl", "getParents"));
        }
        return list;
    }

    public long getTime() {
        return this.myTimeCommitParents.getTime();
    }

    @NotNull
    public final String getSubject() {
        String string = this.mySubject;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsShortCommitDetailsImpl", "getSubject"));
        }
        return string;
    }

    @NotNull
    public final VcsUser getAuthor() {
        VcsUser vcsUser = this.myAuthor;
        if (vcsUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsShortCommitDetailsImpl", "getAuthor"));
        }
        return vcsUser;
    }

    public String toString() {
        return this.getHash().toShortString() + "(" + this.getSubject() + ")";
    }
}

