/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graphmodel.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.vcs.log.compressedlist.UpdateRequest;
import com.intellij.vcs.log.graph.Graph;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.mutable.MutableGraph;
import com.intellij.vcs.log.graphmodel.FragmentManager;
import com.intellij.vcs.log.graphmodel.GraphModel;
import com.intellij.vcs.log.graphmodel.fragment.FragmentManagerImpl;
import com.intellij.vcs.log.graphmodel.impl.BranchVisibleNodes;
import com.intellij.vcs.log.graphmodel.impl.GraphBranchShowFixer;
import com.intellij.vcs.log.graphmodel.impl.GraphDecoratorImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GraphModelImpl
implements GraphModel {
    private final MutableGraph graph;
    private final FragmentManagerImpl fragmentManager;
    private final BranchVisibleNodes visibleNodes;
    private final List<Consumer<UpdateRequest>> listeners = new ArrayList<Consumer<UpdateRequest>>();
    private final GraphBranchShowFixer branchShowFixer;
    private static final Logger LOG = Logger.getInstance(GraphModelImpl.class);
    private Function<Node, Boolean> isStartedBranchVisibilityNode = new Function<Node, Boolean>(){

        @NotNull
        public Boolean fun(@NotNull Node key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl$1", "fun"));
            }
            Boolean bl = true;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl$1", "fun"));
            }
            return bl;
        }
    };

    public GraphModelImpl(MutableGraph graph) {
        this.graph = graph;
        this.fragmentManager = new FragmentManagerImpl(graph, new FragmentManagerImpl.CallBackFunction(){

            @Override
            public UpdateRequest runIntermediateUpdate(@NotNull Node upNode, @NotNull Node downNode) {
                if (upNode == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl$2", "runIntermediateUpdate"));
                }
                if (downNode == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl$2", "runIntermediateUpdate"));
                }
                return GraphModelImpl.this.updateIntermediate(upNode, downNode);
            }

            @Override
            public void fullUpdate() {
                GraphModelImpl.this.fullUpdate();
            }
        });
        this.visibleNodes = new BranchVisibleNodes(graph);
        this.visibleNodes.setVisibleNodes(this.visibleNodes.generateVisibleBranchesNodes(this.isStartedBranchVisibilityNode));
        this.branchShowFixer = new GraphBranchShowFixer(graph, this.fragmentManager);
        graph.setGraphDecorator(new GraphDecoratorImpl(this.fragmentManager.getGraphPreDecorator(), new Function<Node, Boolean>(){

            @NotNull
            public Boolean fun(@NotNull Node key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl$3", "fun"));
                }
                Boolean bl = GraphModelImpl.this.visibleNodes.isVisibleNode(key);
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl$3", "fun"));
                }
                return bl;
            }
        }));
        graph.updateVisibleRows();
    }

    @NotNull
    private UpdateRequest updateIntermediate(@NotNull Node upNode, @NotNull Node downNode) {
        if (upNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl", "updateIntermediate"));
        }
        if (downNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl", "updateIntermediate"));
        }
        int upRowIndex = upNode.getRowIndex();
        int downRowIndex = downNode.getRowIndex();
        this.graph.updateVisibleRows();
        UpdateRequest updateRequest = UpdateRequest.buildFromToInterval(upRowIndex, downRowIndex, upNode.getRowIndex(), downNode.getRowIndex());
        this.callUpdateListener(updateRequest);
        UpdateRequest updateRequest2 = updateRequest;
        if (updateRequest2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl", "updateIntermediate"));
        }
        return updateRequest2;
    }

    private void fullUpdate() {
        int oldSize = this.graph.getNodeRows().size();
        this.graph.updateVisibleRows();
        int newSize = this.graph.getNodeRows().size();
        if (newSize == 0) {
            return;
        }
        if (oldSize == 0) {
            LOG.error("Old size can't be 0 if newSize is not 0. newSize: " + newSize);
            return;
        }
        int newTo = newSize - 1;
        int oldTo = oldSize - 1;
        UpdateRequest updateRequest = UpdateRequest.buildFromToInterval(0, oldTo, 0, newTo);
        this.callUpdateListener(updateRequest);
    }

    @Override
    @NotNull
    public Graph getGraph() {
        MutableGraph mutableGraph = this.graph;
        if (mutableGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl", "getGraph"));
        }
        return mutableGraph;
    }

    @Override
    public void setVisibleBranchesNodes(@NotNull Function<Node, Boolean> isStartedNode) {
        if (isStartedNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl", "setVisibleBranchesNodes"));
        }
        this.isStartedBranchVisibilityNode = isStartedNode;
        Set<Node> prevVisibleNodes = this.visibleNodes.getVisibleNodes();
        Set<Node> newVisibleNodes = this.visibleNodes.generateVisibleBranchesNodes(isStartedNode);
        this.branchShowFixer.fixCrashBranches(prevVisibleNodes, newVisibleNodes);
        this.visibleNodes.setVisibleNodes(newVisibleNodes);
        this.fullUpdate();
    }

    @Override
    @NotNull
    public FragmentManager getFragmentManager() {
        FragmentManagerImpl fragmentManagerImpl = this.fragmentManager;
        if (fragmentManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl", "getFragmentManager"));
        }
        return fragmentManagerImpl;
    }

    private void callUpdateListener(@NotNull UpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl", "callUpdateListener"));
        }
        for (Consumer<UpdateRequest> listener : this.listeners) {
            listener.consume((Object)updateRequest);
        }
    }

    @Override
    public void addUpdateListener(@NotNull Consumer<UpdateRequest> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphModelImpl", "addUpdateListener"));
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeAllListeners() {
        this.listeners.clear();
    }
}

