/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graphmodel.impl;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.mutable.GraphDecorator;
import com.intellij.vcs.log.graphmodel.FragmentManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphDecoratorImpl
implements GraphDecorator {
    private final FragmentManager.GraphPreDecorator preDecorator;
    private final Function<Node, Boolean> branchVisibleNodes;

    public GraphDecoratorImpl(FragmentManager.GraphPreDecorator preDecorator, Function<Node, Boolean> branchVisibleNodes) {
        this.preDecorator = preDecorator;
        this.branchVisibleNodes = branchVisibleNodes;
    }

    @Override
    public boolean isVisibleNode(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphDecoratorImpl", "isVisibleNode"));
        }
        return this.preDecorator.isVisibleNode(node) && (Boolean)this.branchVisibleNodes.fun((Object)node) != false;
    }

    @Override
    @NotNull
    public List<Edge> getDownEdges(@NotNull Node node, @NotNull List<Edge> innerDownEdges) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphDecoratorImpl", "getDownEdges"));
        }
        if (innerDownEdges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graphmodel/impl/GraphDecoratorImpl", "getDownEdges"));
        }
        Edge edge = this.preDecorator.getHideFragmentDownEdge(node);
        if (edge != null) {
            SmartList smartList = new SmartList((Object)edge);
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/GraphDecoratorImpl", "getDownEdges"));
            }
            return smartList;
        }
        List<Edge> list = Collections.unmodifiableList(innerDownEdges);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/GraphDecoratorImpl", "getDownEdges"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Edge> getUpEdges(@NotNull Node node, @NotNull List<Edge> innerUpEdges) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphDecoratorImpl", "getUpEdges"));
        }
        if (innerUpEdges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graphmodel/impl/GraphDecoratorImpl", "getUpEdges"));
        }
        Edge hideFragmentUpEdge = this.preDecorator.getHideFragmentUpEdge(node);
        if (hideFragmentUpEdge != null) {
            SmartList smartList = new SmartList((Object)hideFragmentUpEdge);
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/GraphDecoratorImpl", "getUpEdges"));
            }
            return smartList;
        }
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : innerUpEdges) {
            if (!this.isVisibleNode(edge.getUpNode())) continue;
            edges.add(edge);
        }
        ArrayList<Edge> arrayList = edges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/GraphDecoratorImpl", "getUpEdges"));
        }
        return arrayList;
    }
}

