/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graphmodel.impl;

import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.mutable.MutableGraph;
import com.intellij.vcs.log.graph.mutable.elements.MutableNode;
import com.intellij.vcs.log.graph.mutable.elements.MutableNodeRow;
import com.intellij.vcs.log.graphmodel.FragmentManager;
import com.intellij.vcs.log.graphmodel.GraphFragment;
import com.intellij.vcs.log.graphmodel.fragment.FragmentManagerImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GraphBranchShowFixer {
    private final MutableGraph graph;
    private final FragmentManagerImpl fragmentManager;
    private Set<Node> prevVisibleNodes;
    private Set<Node> newVisibleNodes;
    private FragmentManager.GraphPreDecorator fragmentGraphDecorator;

    public GraphBranchShowFixer(MutableGraph graph, FragmentManagerImpl fragmentManager) {
        this.graph = graph;
        this.fragmentManager = fragmentManager;
    }

    public void fixCrashBranches(@NotNull Set<Node> prevVisibleNodes, @NotNull Set<Node> newVisibleNodes) {
        if (prevVisibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphBranchShowFixer", "fixCrashBranches"));
        }
        if (newVisibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graphmodel/impl/GraphBranchShowFixer", "fixCrashBranches"));
        }
        this.prevVisibleNodes = prevVisibleNodes;
        this.newVisibleNodes = newVisibleNodes;
        this.fragmentGraphDecorator = this.fragmentManager.getGraphPreDecorator();
        HashSet<Node> badHiddenNode = new HashSet<Node>();
        for (MutableNodeRow row : this.graph.getAllRows()) {
            for (MutableNode node : row.getInnerNodeList()) {
                if (!this.isEssentialNode(node)) continue;
                badHiddenNode.addAll(this.badHiddenNodes(node));
            }
        }
        this.showNodes(badHiddenNode);
    }

    private Set<Node> badHiddenNodes(@NotNull MutableNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphBranchShowFixer", "badHiddenNodes"));
        }
        if (this.fragmentGraphDecorator.getHideFragmentDownEdge(node) != null) {
            return Collections.emptySet();
        }
        HashSet<Node> badHiddenNodes = new HashSet<Node>();
        for (Edge edge : node.getInnerDownEdges()) {
            Node downNode = edge.getDownNode();
            if (this.fragmentGraphDecorator.isVisibleNode(downNode)) continue;
            badHiddenNodes.add(downNode);
        }
        return badHiddenNodes;
    }

    private boolean isEssentialNode(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphBranchShowFixer", "isEssentialNode"));
        }
        return this.newVisibleNodes.contains(node) && !this.prevVisibleNodes.contains(node) && this.fragmentGraphDecorator.isVisibleNode(node);
    }

    @NotNull
    private Edge getExternalHideEdge(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/GraphBranchShowFixer", "getExternalHideEdge"));
        }
        while (!this.fragmentGraphDecorator.isVisibleNode(node)) {
            MutableNode thisNode = (MutableNode)node;
            if (thisNode.getInnerDownEdges().size() == 0) {
                throw new IllegalStateException("not found down visible node of hide node");
            }
            node = thisNode.getInnerDownEdges().get(0).getDownNode();
        }
        Edge edge = this.fragmentGraphDecorator.getHideFragmentUpEdge(node);
        if (edge == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/GraphBranchShowFixer", "getExternalHideEdge"));
        }
        return edge;
    }

    private void showNodes(Set<Node> nodes) {
        for (Node node : nodes) {
            while (!this.fragmentGraphDecorator.isVisibleNode(node)) {
                Edge hideEdge = this.getExternalHideEdge(node);
                GraphFragment fragment = this.fragmentManager.relateFragment(hideEdge);
                assert (fragment != null) : "bad hide edge" + hideEdge;
                this.fragmentManager.show(fragment);
            }
        }
    }
}

