/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graphmodel.impl;

import com.intellij.util.Function;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.mutable.MutableGraph;
import com.intellij.vcs.log.graph.mutable.elements.MutableNode;
import com.intellij.vcs.log.graph.mutable.elements.MutableNodeRow;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BranchVisibleNodes {
    @NotNull
    private final MutableGraph myGraph;
    @NotNull
    private Set<Node> myVisibleNodes;

    public BranchVisibleNodes(@NotNull MutableGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/BranchVisibleNodes", "<init>"));
        }
        this.myVisibleNodes = Collections.emptySet();
        this.myGraph = graph;
    }

    @NotNull
    public Set<Node> generateVisibleBranchesNodes(@NotNull Function<Node, Boolean> isStartedNode) {
        if (isStartedNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/BranchVisibleNodes", "generateVisibleBranchesNodes"));
        }
        HashSet<Node> visibleNodes = new HashSet<Node>();
        for (MutableNodeRow row : this.myGraph.getAllRows()) {
            for (MutableNode node : row.getInnerNodeList()) {
                if (((Boolean)isStartedNode.fun((Object)node)).booleanValue()) {
                    visibleNodes.add(node);
                }
                if (!((Boolean)isStartedNode.fun((Object)node)).booleanValue() && !visibleNodes.contains(node)) continue;
                for (Edge edge : node.getInnerDownEdges()) {
                    visibleNodes.add(edge.getDownNode());
                }
            }
        }
        HashSet<Node> hashSet = visibleNodes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/impl/BranchVisibleNodes", "generateVisibleBranchesNodes"));
        }
        return hashSet;
    }

    public void setVisibleNodes(@NotNull Set<Node> visibleNodes) {
        if (visibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/BranchVisibleNodes", "setVisibleNodes"));
        }
        this.myVisibleNodes = visibleNodes;
    }

    public Set<Node> getVisibleNodes() {
        return Collections.unmodifiableSet(this.myVisibleNodes);
    }

    public boolean isVisibleNode(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/impl/BranchVisibleNodes", "isVisibleNode"));
        }
        return this.myVisibleNodes.contains(node);
    }
}

